/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Anycast static IP list collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnycastIpListCollection implements SdkPojo, Serializable,
        ToCopyableBuilder<AnycastIpListCollection.Builder, AnycastIpListCollection> {
    private static final SdkField<List<AnycastIpListSummary>> ITEMS_FIELD = SdkField
            .<List<AnycastIpListSummary>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(AnycastIpListCollection::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AnycastIpListSummary")
                            .memberFieldInfo(
                                    SdkField.<AnycastIpListSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnycastIpListSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AnycastIpListSummary")
                                                    .unmarshallLocationName("AnycastIpListSummary").build()).build()).build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(AnycastIpListCollection::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(AnycastIpListCollection::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(AnycastIpListCollection::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(AnycastIpListCollection::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(AnycastIpListCollection::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, MARKER_FIELD,
            NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, IS_TRUNCATED_FIELD, QUANTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AnycastIpListSummary> items;

    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private AnycastIpListCollection(BuilderImpl builder) {
        this.items = builder.items;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a> structure type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a> structure
     *         type.
     */
    public final List<AnycastIpListSummary> items() {
        return items;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list. The response includes items in
     * the list that occur after the marker. To get the next page of the list, set this field's value to the value of
     * <code>NextMarker</code> from the current page's response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list. The response includes
     *         items in the list that occur after the marker. To get the next page of the list, set this field's value
     *         to the value of <code>NextMarker</code> from the current page's response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Indicates the next page of the Anycast static IP list collection. To get the next page of the list, use this
     * value in the <code>Marker</code> field of your request.
     * </p>
     * 
     * @return Indicates the next page of the Anycast static IP list collection. To get the next page of the list, use
     *         this value in the <code>Marker</code> field of your request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of Anycast static IP list collections that you want returned in the response.
     * </p>
     * 
     * @return The maximum number of Anycast static IP list collections that you want returned in the response.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * If there are more items in the list collection than are in this response, this value is <code>true</code>.
     * </p>
     * 
     * @return If there are more items in the list collection than are in this response, this value is <code>true</code>
     *         .
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The quantity of Anycast static IP lists in the collection.
     * </p>
     * 
     * @return The quantity of Anycast static IP lists in the collection.
     */
    public final Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnycastIpListCollection)) {
            return false;
        }
        AnycastIpListCollection other = (AnycastIpListCollection) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnycastIpListCollection").add("Items", hasItems() ? items() : null).add("Marker", marker())
                .add("NextMarker", nextMarker()).add("MaxItems", maxItems()).add("IsTruncated", isTruncated())
                .add("Quantity", quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Items", ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Quantity", QUANTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnycastIpListCollection, T> g) {
        return obj -> g.apply((AnycastIpListCollection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnycastIpListCollection> {
        /**
         * <p>
         * Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a> structure
         * type.
         * </p>
         * 
         * @param items
         *        Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a>
         *        structure type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AnycastIpListSummary> items);

        /**
         * <p>
         * Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a> structure
         * type.
         * </p>
         * 
         * @param items
         *        Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a>
         *        structure type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AnycastIpListSummary... items);

        /**
         * <p>
         * Items in the Anycast static IP list collection. Each item is of the <a>AnycastIpListSummary</a> structure
         * type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<AnycastIpListSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<AnycastIpListSummary>)
         */
        Builder items(Consumer<AnycastIpListSummary.Builder>... items);

        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list. The response includes items
         * in the list that occur after the marker. To get the next page of the list, set this field's value to the
         * value of <code>NextMarker</code> from the current page's response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list. The response includes
         *        items in the list that occur after the marker. To get the next page of the list, set this field's
         *        value to the value of <code>NextMarker</code> from the current page's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Indicates the next page of the Anycast static IP list collection. To get the next page of the list, use this
         * value in the <code>Marker</code> field of your request.
         * </p>
         * 
         * @param nextMarker
         *        Indicates the next page of the Anycast static IP list collection. To get the next page of the list,
         *        use this value in the <code>Marker</code> field of your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of Anycast static IP list collections that you want returned in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of Anycast static IP list collections that you want returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * If there are more items in the list collection than are in this response, this value is <code>true</code>.
         * </p>
         * 
         * @param isTruncated
         *        If there are more items in the list collection than are in this response, this value is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The quantity of Anycast static IP lists in the collection.
         * </p>
         * 
         * @param quantity
         *        The quantity of Anycast static IP lists in the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);
    }

    static final class BuilderImpl implements Builder {
        private List<AnycastIpListSummary> items = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AnycastIpListCollection model) {
            items(model.items);
            marker(model.marker);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            isTruncated(model.isTruncated);
            quantity(model.quantity);
        }

        public final List<AnycastIpListSummary.Builder> getItems() {
            List<AnycastIpListSummary.Builder> result = AnycastIpListSummariesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AnycastIpListSummary.BuilderImpl> items) {
            this.items = AnycastIpListSummariesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AnycastIpListSummary> items) {
            this.items = AnycastIpListSummariesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AnycastIpListSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AnycastIpListSummary.Builder>... items) {
            items(Stream.of(items).map(c -> AnycastIpListSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public AnycastIpListCollection build() {
            return new AnycastIpListCollection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
