/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.auth;

import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public enum PemObjectType {
    PRIVATE_KEY_PKCS1("-----BEGIN RSA PRIVATE KEY-----"),
    PRIVATE_KEY_PKCS8("-----BEGIN PRIVATE KEY-----"),
    PUBLIC_KEY_X509("-----BEGIN PUBLIC KEY-----"),
    CERTIFICATE_X509("-----BEGIN CERTIFICATE-----");

    private final String beginMarker;

    private PemObjectType(String beginMarker) {
        this.beginMarker = beginMarker;
    }

    public String getBeginMarker() {
        return this.beginMarker;
    }

    public static PemObjectType fromBeginMarker(String beginMarker) {
        return Arrays.stream(PemObjectType.values()).filter(e -> e.getBeginMarker().equals(beginMarker)).findFirst().orElse(null);
    }
}

