/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The import source for the key value store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSource implements SdkPojo, Serializable, ToCopyableBuilder<ImportSource.Builder, ImportSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceType")
            .getter(getter(ImportSource::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType")
                    .unmarshallLocationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceARN")
            .getter(getter(ImportSource::sourceARN))
            .setter(setter(Builder::sourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceARN")
                    .unmarshallLocationName("SourceARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            SOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final String sourceARN;

    private ImportSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceARN = builder.sourceARN;
    }

    /**
     * <p>
     * The source type of the import source for the key value store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ImportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the import source for the key value store.
     * @see ImportSourceType
     */
    public final ImportSourceType sourceType() {
        return ImportSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source type of the import source for the key value store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ImportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the import source for the key value store.
     * @see ImportSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the import source for the key value store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the import source for the key value store.
     */
    public final String sourceARN() {
        return sourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSource)) {
            return false;
        }
        ImportSource other = (ImportSource) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(sourceARN(), other.sourceARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSource").add("SourceType", sourceTypeAsString()).add("SourceARN", sourceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "SourceARN":
            return Optional.ofNullable(clazz.cast(sourceARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSource, T> g) {
        return obj -> g.apply((ImportSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportSource> {
        /**
         * <p>
         * The source type of the import source for the key value store.
         * </p>
         * 
         * @param sourceType
         *        The source type of the import source for the key value store.
         * @see ImportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source type of the import source for the key value store.
         * </p>
         * 
         * @param sourceType
         *        The source type of the import source for the key value store.
         * @see ImportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportSourceType
         */
        Builder sourceType(ImportSourceType sourceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the import source for the key value store.
         * </p>
         * 
         * @param sourceARN
         *        The Amazon Resource Name (ARN) of the import source for the key value store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceARN(String sourceARN);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private String sourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSource model) {
            sourceType(model.sourceType);
            sourceARN(model.sourceARN);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ImportSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceARN() {
            return sourceARN;
        }

        public final void setSourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
        }

        @Override
        public final Builder sourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
            return this;
        }

        @Override
        public ImportSource build() {
            return new ImportSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
