/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the percentage of traffic to send to a staging distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousDeploymentSingleWeightConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousDeploymentSingleWeightConfig.Builder, ContinuousDeploymentSingleWeightConfig> {
    private static final SdkField<Float> WEIGHT_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("Weight")
            .getter(getter(ContinuousDeploymentSingleWeightConfig::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight")
                    .unmarshallLocationName("Weight").build()).build();

    private static final SdkField<SessionStickinessConfig> SESSION_STICKINESS_CONFIG_FIELD = SdkField
            .<SessionStickinessConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SessionStickinessConfig")
            .getter(getter(ContinuousDeploymentSingleWeightConfig::sessionStickinessConfig))
            .setter(setter(Builder::sessionStickinessConfig))
            .constructor(SessionStickinessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionStickinessConfig")
                    .unmarshallLocationName("SessionStickinessConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHT_FIELD,
            SESSION_STICKINESS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float weight;

    private final SessionStickinessConfig sessionStickinessConfig;

    private ContinuousDeploymentSingleWeightConfig(BuilderImpl builder) {
        this.weight = builder.weight;
        this.sessionStickinessConfig = builder.sessionStickinessConfig;
    }

    /**
     * <p>
     * The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and 0.15.
     * For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
     * </p>
     * 
     * @return The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and
     *         0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
     */
    public final Float weight() {
        return weight;
    }

    /**
     * Returns the value of the SessionStickinessConfig property for this object.
     * 
     * @return The value of the SessionStickinessConfig property for this object.
     */
    public final SessionStickinessConfig sessionStickinessConfig() {
        return sessionStickinessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(sessionStickinessConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousDeploymentSingleWeightConfig)) {
            return false;
        }
        ContinuousDeploymentSingleWeightConfig other = (ContinuousDeploymentSingleWeightConfig) obj;
        return Objects.equals(weight(), other.weight())
                && Objects.equals(sessionStickinessConfig(), other.sessionStickinessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousDeploymentSingleWeightConfig").add("Weight", weight())
                .add("SessionStickinessConfig", sessionStickinessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "SessionStickinessConfig":
            return Optional.ofNullable(clazz.cast(sessionStickinessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinuousDeploymentSingleWeightConfig, T> g) {
        return obj -> g.apply((ContinuousDeploymentSingleWeightConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousDeploymentSingleWeightConfig> {
        /**
         * <p>
         * The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0 and
         * 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
         * </p>
         * 
         * @param weight
         *        The percentage of traffic to send to a staging distribution, expressed as a decimal number between 0
         *        and 0.15. For example, a value of 0.10 means 10% of traffic is sent to the staging distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Float weight);

        /**
         * Sets the value of the SessionStickinessConfig property for this object.
         *
         * @param sessionStickinessConfig
         *        The new value for the SessionStickinessConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionStickinessConfig(SessionStickinessConfig sessionStickinessConfig);

        /**
         * Sets the value of the SessionStickinessConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SessionStickinessConfig.Builder} avoiding
         * the need to create one manually via {@link SessionStickinessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionStickinessConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #sessionStickinessConfig(SessionStickinessConfig)}.
         * 
         * @param sessionStickinessConfig
         *        a consumer that will call methods on {@link SessionStickinessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionStickinessConfig(SessionStickinessConfig)
         */
        default Builder sessionStickinessConfig(Consumer<SessionStickinessConfig.Builder> sessionStickinessConfig) {
            return sessionStickinessConfig(SessionStickinessConfig.builder().applyMutation(sessionStickinessConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float weight;

        private SessionStickinessConfig sessionStickinessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousDeploymentSingleWeightConfig model) {
            weight(model.weight);
            sessionStickinessConfig(model.sessionStickinessConfig);
        }

        public final Float getWeight() {
            return weight;
        }

        public final void setWeight(Float weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Float weight) {
            this.weight = weight;
            return this;
        }

        public final SessionStickinessConfig.Builder getSessionStickinessConfig() {
            return sessionStickinessConfig != null ? sessionStickinessConfig.toBuilder() : null;
        }

        public final void setSessionStickinessConfig(SessionStickinessConfig.BuilderImpl sessionStickinessConfig) {
            this.sessionStickinessConfig = sessionStickinessConfig != null ? sessionStickinessConfig.build() : null;
        }

        @Override
        public final Builder sessionStickinessConfig(SessionStickinessConfig sessionStickinessConfig) {
            this.sessionStickinessConfig = sessionStickinessConfig;
            return this;
        }

        @Override
        public ContinuousDeploymentSingleWeightConfig build() {
            return new ContinuousDeploymentSingleWeightConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
