/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FrameOptionsList {
    DENY("DENY"),
    SAMEORIGIN("SAMEORIGIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FrameOptionsList> VALUE_MAP;
    private final String value;

    private FrameOptionsList(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FrameOptionsList fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FrameOptionsList> knownValues() {
        EnumSet<FrameOptionsList> knownValues = EnumSet.allOf(FrameOptionsList.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FrameOptionsList.class, FrameOptionsList::toString);
    }
}

