/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClientBuilder;
import software.amazon.awssdk.services.cloudfront.CloudFrontServiceClientConfiguration;
import software.amazon.awssdk.services.cloudfront.DefaultCloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.DefaultCloudFrontBaseClientBuilder;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointProvider;

@SdkInternalApi
final class DefaultCloudFrontAsyncClientBuilder
extends DefaultCloudFrontBaseClientBuilder<CloudFrontAsyncClientBuilder, CloudFrontAsyncClient>
implements CloudFrontAsyncClientBuilder {
    DefaultCloudFrontAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudFrontAsyncClientBuilder endpointProvider(CloudFrontEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudFrontAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudFrontAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudFrontServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudFrontAsyncClient client = new DefaultCloudFrontAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudFrontServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudFrontServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

