/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ScannedResource;

public class ListResourceScanRelatedResourcesPublisher
implements SdkPublisher<ListResourceScanRelatedResourcesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListResourceScanRelatedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceScanRelatedResourcesPublisher(CloudFormationAsyncClient client, ListResourceScanRelatedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceScanRelatedResourcesPublisher(CloudFormationAsyncClient client, ListResourceScanRelatedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceScanRelatedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceScanRelatedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScannedResource> relatedResources() {
        return this.flatMapIterable(response -> response.relatedResources());
    }

    private class ListResourceScanRelatedResourcesResponseFetcher
    implements AsyncPageFetcher<ListResourceScanRelatedResourcesResponse> {
        private ListResourceScanRelatedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScanRelatedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceScanRelatedResourcesResponse> nextPage(ListResourceScanRelatedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScanRelatedResourcesPublisher.this.client.listResourceScanRelatedResources(ListResourceScanRelatedResourcesPublisher.this.firstRequest);
            }
            return ListResourceScanRelatedResourcesPublisher.this.client.listResourceScanRelatedResources((ListResourceScanRelatedResourcesRequest)((Object)ListResourceScanRelatedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

