/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.Change;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;

public class DescribeChangeSetPublisher
implements SdkPublisher<DescribeChangeSetResponse> {
    private final CloudFormationAsyncClient client;
    private final DescribeChangeSetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeChangeSetPublisher(CloudFormationAsyncClient client, DescribeChangeSetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeChangeSetPublisher(CloudFormationAsyncClient client, DescribeChangeSetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeChangeSetResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeChangeSetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Change> changes() {
        return this.flatMapIterable(response -> response.changes());
    }

    private class DescribeChangeSetResponseFetcher
    implements AsyncPageFetcher<DescribeChangeSetResponse> {
        private DescribeChangeSetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeChangeSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeChangeSetResponse> nextPage(DescribeChangeSetResponse previousPage) {
            if (previousPage == null) {
                return DescribeChangeSetPublisher.this.client.describeChangeSet(DescribeChangeSetPublisher.this.firstRequest);
            }
            return DescribeChangeSetPublisher.this.client.describeChangeSet((DescribeChangeSetRequest)((Object)DescribeChangeSetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

