/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorAction;

public class ListStackRefactorActionsPublisher
implements SdkPublisher<ListStackRefactorActionsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackRefactorActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackRefactorActionsPublisher(CloudFormationAsyncClient client, ListStackRefactorActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackRefactorActionsPublisher(CloudFormationAsyncClient client, ListStackRefactorActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackRefactorActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackRefactorActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackRefactorAction> stackRefactorActions() {
        return this.flatMapIterable(response -> response.stackRefactorActions());
    }

    private class ListStackRefactorActionsResponseFetcher
    implements AsyncPageFetcher<ListStackRefactorActionsResponse> {
        private ListStackRefactorActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackRefactorActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackRefactorActionsResponse> nextPage(ListStackRefactorActionsResponse previousPage) {
            if (previousPage == null) {
                return ListStackRefactorActionsPublisher.this.client.listStackRefactorActions(ListStackRefactorActionsPublisher.this.firstRequest);
            }
            return ListStackRefactorActionsPublisher.this.client.listStackRefactorActions((ListStackRefactorActionsRequest)((Object)ListStackRefactorActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

