/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypeFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanFilter> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(ScanFilter.getter(ScanFilter::types)).setter(ScanFilter.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> types;

    private ScanFilter(BuilderImpl builder) {
        this.types = builder.types;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanFilter)) {
            return false;
        }
        ScanFilter other = (ScanFilter)obj;
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types());
    }

    public final String toString() {
        return ToString.builder((String)"ScanFilter").add("Types", this.hasTypes() ? this.types() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanFilter, T> g) {
        return obj -> g.apply((ScanFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanFilter model) {
            this.types(model.types);
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ResourceTypeFiltersCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = ResourceTypeFiltersCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public ScanFilter build() {
            return new ScanFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanFilter> {
        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);
    }
}

