/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudformation.model.ActivateOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.ActivateOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeactivateOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.DeactivateOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeResourceScanRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeResourceScanResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.GetGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetHookResultRequest;
import software.amazon.awssdk.services.cloudformation.model.GetHookResultResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetAutoDeploymentTargetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetAutoDeploymentTargetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StartResourceScanRequest;
import software.amazon.awssdk.services.cloudformation.model.StartResourceScanResponse;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TestTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.TestTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeChangeSetPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListGeneratedTemplatesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanRelatedResourcesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanResourcesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListResourceScansPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorActionsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationAsyncWaiter;

/**
 * Service client for accessing AWS CloudFormation asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>CloudFormation</fullname>
 * <p>
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure deployments predictably and
 * repeatedly. You can use CloudFormation to leverage Amazon Web Services products, such as Amazon Elastic Compute
 * Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, ELB, and Amazon EC2 Auto Scaling to build
 * highly reliable, highly scalable, cost-effective applications without creating or configuring the underlying Amazon
 * Web Services infrastructure.
 * </p>
 * <p>
 * With CloudFormation, you declare all your resources and dependencies in a template file. The template defines a
 * collection of resources as a single unit called a stack. CloudFormation creates and deletes all member resources of
 * the stack together and manages all dependencies between the resources for you.
 * </p>
 * <p>
 * For more information about CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">CloudFormation
 * product page</a>.
 * </p>
 * <p>
 * CloudFormation makes use of other Amazon Web Services products. If you need additional technical information about a
 * specific Amazon Web Services product, you can find the product's technical documentation at <a
 * href="https://docs.aws.amazon.com/">docs.aws.amazon.com</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFormationAsyncClient extends AwsClient {
    String SERVICE_NAME = "cloudformation";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudformation";

    /**
     * <p>
     * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated,
     * the management account has permissions to create and manage StackSets for your organization.
     * </p>
     *
     * @param activateOrganizationsAccessRequest
     * @return A Java Future containing the result of the ActivateOrganizationsAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ActivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateOrganizationsAccessResponse> activateOrganizationsAccess(
            ActivateOrganizationsAccessRequest activateOrganizationsAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated,
     * the management account has permissions to create and manage StackSets for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ActivateOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param activateOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ActivateOrganizationsAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ActivateOrganizationsAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ActivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateOrganizationsAccessResponse> activateOrganizationsAccess(
            Consumer<ActivateOrganizationsAccessRequest.Builder> activateOrganizationsAccessRequest) {
        return activateOrganizationsAccess(ActivateOrganizationsAccessRequest.builder()
                .applyMutation(activateOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Activates a public third-party extension, such as a resource or module, to make it available for use in stack
     * templates in your current account and Region. It can also create CloudFormation Hooks, which allow you to
     * evaluate resource configurations before CloudFormation provisions them. Hooks integrate with both CloudFormation
     * and Cloud Control API operations.
     * </p>
     * <p>
     * After you activate an extension, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to set specific properties for the extension.
     * </p>
     * <p>
     * To see which extensions have been activated, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html">ListTypes</a>. To see
     * configuration details for an extension, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public-activate-extension.html"
     * >Activate a third-party public extension in your account</a> in the <i>CloudFormation User Guide</i>. For
     * information about creating Hooks, see the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html"
     * >CloudFormation Hooks User Guide</a>.
     * </p>
     *
     * @param activateTypeRequest
     * @return A Java Future containing the result of the ActivateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ActivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivateTypeResponse> activateType(ActivateTypeRequest activateTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a public third-party extension, such as a resource or module, to make it available for use in stack
     * templates in your current account and Region. It can also create CloudFormation Hooks, which allow you to
     * evaluate resource configurations before CloudFormation provisions them. Hooks integrate with both CloudFormation
     * and Cloud Control API operations.
     * </p>
     * <p>
     * After you activate an extension, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to set specific properties for the extension.
     * </p>
     * <p>
     * To see which extensions have been activated, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html">ListTypes</a>. To see
     * configuration details for an extension, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public-activate-extension.html"
     * >Activate a third-party public extension in your account</a> in the <i>CloudFormation User Guide</i>. For
     * information about creating Hooks, see the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html"
     * >CloudFormation Hooks User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link ActivateTypeRequest#builder()}
     * </p>
     *
     * @param activateTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ActivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivateTypeResponse> activateType(Consumer<ActivateTypeRequest.Builder> activateTypeRequest) {
        return activateType(ActivateTypeRequest.builder().applyMutation(activateTypeRequest).build());
    }

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry in your
     * current account and Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param batchDescribeTypeConfigurationsRequest
     * @return A Java Future containing the result of the BatchDescribeTypeConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TypeConfigurationNotFoundException The specified extension configuration can't be found.</li>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.BatchDescribeTypeConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeTypeConfigurationsResponse> batchDescribeTypeConfigurations(
            BatchDescribeTypeConfigurationsRequest batchDescribeTypeConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry in your
     * current account and Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeTypeConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDescribeTypeConfigurationsRequest#builder()}
     * </p>
     *
     * @param batchDescribeTypeConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDescribeTypeConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TypeConfigurationNotFoundException The specified extension configuration can't be found.</li>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.BatchDescribeTypeConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeTypeConfigurationsResponse> batchDescribeTypeConfigurations(
            Consumer<BatchDescribeTypeConfigurationsRequest.Builder> batchDescribeTypeConfigurationsRequest) {
        return batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest.builder()
                .applyMutation(batchDescribeTypeConfigurationsRequest).build());
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the <code>UPDATE_IN_PROGRESS</code> state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the <code>UPDATE_IN_PROGRESS</code> state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelUpdateStackRequest.Builder} avoiding the need
     * to create one manually via {@link CancelUpdateStackRequest#builder()}
     * </p>
     *
     * @param cancelUpdateStackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest.Builder} to create a
     *        request. The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(
            Consumer<CancelUpdateStackRequest.Builder> cancelUpdateStackRequest) {
        return cancelUpdateStack(CancelUpdateStackRequest.builder().applyMutation(cancelUpdateStackRequest).build());
    }

    /**
     * <p>
     * Continues rolling back a stack from <code>UPDATE_ROLLBACK_FAILED</code> to <code>UPDATE_ROLLBACK_COMPLETE</code>
     * state. Depending on the cause of the failure, you can manually fix the error and continue the rollback. By
     * continuing the rollback, you can return your stack to a working state (the <code>UPDATE_ROLLBACK_COMPLETE</code>
     * state) and then try to update the stack again.
     * </p>
     * <p>
     * A stack enters the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation can't roll back all changes
     * after a failed stack update. For example, this might occur when a stack attempts to roll back to an old database
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the instance was deleted, it
     * assumes the instance still exists and attempts to roll back to it, causing the update rollback to fail.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html"
     * >Continue rolling back an update</a> in the <i>CloudFormation User Guide</i>. For information for troubleshooting
     * a failed update rollback, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * >Update rollback failed</a>.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Continues rolling back a stack from <code>UPDATE_ROLLBACK_FAILED</code> to <code>UPDATE_ROLLBACK_COMPLETE</code>
     * state. Depending on the cause of the failure, you can manually fix the error and continue the rollback. By
     * continuing the rollback, you can return your stack to a working state (the <code>UPDATE_ROLLBACK_COMPLETE</code>
     * state) and then try to update the stack again.
     * </p>
     * <p>
     * A stack enters the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation can't roll back all changes
     * after a failed stack update. For example, this might occur when a stack attempts to roll back to an old database
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the instance was deleted, it
     * assumes the instance still exists and attempts to roll back to it, causing the update rollback to fail.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html"
     * >Continue rolling back an update</a> in the <i>CloudFormation User Guide</i>. For information for troubleshooting
     * a failed update rollback, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * >Update rollback failed</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContinueUpdateRollbackRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueUpdateRollbackRequest#builder()}
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest.Builder} to
     *        create a request. The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            Consumer<ContinueUpdateRollbackRequest.Builder> continueUpdateRollbackRequest) {
        return continueUpdateRollback(ContinueUpdateRollbackRequest.builder().applyMutation(continueUpdateRollbackRequest)
                .build());
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(CreateChangeSetRequest createChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateChangeSetRequest#builder()}
     * </p>
     *
     * @param createChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest.Builder} to create a
     *        request. The input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(
            Consumer<CreateChangeSetRequest.Builder> createChangeSetRequest) {
        return createChangeSet(CreateChangeSetRequest.builder().applyMutation(createChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates a template from existing resources that are not already managed with CloudFormation. You can check the
     * status of the template generation using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     *
     * @param createGeneratedTemplateRequest
     * @return A Java Future containing the result of the CreateGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>ConcurrentResourcesLimitExceededException No more than 5 generated templates can be in an
     *         <code>InProgress</code> or <code>Pending</code> status at one time. This error is also returned if a
     *         generated template that is in an <code>InProgress</code> or <code>Pending</code> status is attempted to
     *         be updated or deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGeneratedTemplateResponse> createGeneratedTemplate(
            CreateGeneratedTemplateRequest createGeneratedTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template from existing resources that are not already managed with CloudFormation. You can check the
     * status of the template generation using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGeneratedTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateGeneratedTemplateRequest#builder()}
     * </p>
     *
     * @param createGeneratedTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateGeneratedTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>ConcurrentResourcesLimitExceededException No more than 5 generated templates can be in an
     *         <code>InProgress</code> or <code>Pending</code> status at one time. This error is also returned if a
     *         generated template that is in an <code>InProgress</code> or <code>Pending</code> status is attempted to
     *         be updated or deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGeneratedTemplateResponse> createGeneratedTemplate(
            Consumer<CreateGeneratedTemplateRequest.Builder> createGeneratedTemplateRequest) {
        return createGeneratedTemplate(CreateGeneratedTemplateRequest.builder().applyMutation(createGeneratedTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * For more information about creating a stack and monitoring stack progress, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * For more information about creating a stack and monitoring stack progress, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateStackRequest.Builder} to create a
     *        request. The input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(Consumer<CreateStackRequest.Builder> createStackRequest) {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack
     * instance refers to a stack in a specific account and Region. You must specify at least one value for either
     * <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for
     * <code>Regions</code>.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>CreateStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createStackInstancesRequest
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            CreateStackInstancesRequest createStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack
     * instance refers to a stack in a specific account and Region. You must specify at least one value for either
     * <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for
     * <code>Regions</code>.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>CreateStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStackInstancesRequest#builder()}
     * </p>
     *
     * @param createStackInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            Consumer<CreateStackInstancesRequest.Builder> createStackInstancesRequest) {
        return createStackInstances(CreateStackInstancesRequest.builder().applyMutation(createStackInstancesRequest).build());
    }

    /**
     * <p>
     * Creates a refactor across multiple stacks, with the list of stacks and resources that are affected.
     * </p>
     *
     * @param createStackRefactorRequest
     * @return A Java Future containing the result of the CreateStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackRefactorResponse> createStackRefactor(
            CreateStackRefactorRequest createStackRefactorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a refactor across multiple stacks, with the list of stacks and resources that are affected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRefactorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStackRefactorRequest#builder()}
     * </p>
     *
     * @param createStackRefactorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateStackRefactorRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackRefactorResponse> createStackRefactor(
            Consumer<CreateStackRefactorRequest.Builder> createStackRefactorRequest) {
        return createStackRefactor(CreateStackRefactorRequest.builder().applyMutation(createStackRefactorRequest).build());
    }

    /**
     * <p>
     * Creates a StackSet.
     * </p>
     *
     * @param createStackSetRequest
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(CreateStackSetRequest createStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a StackSet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackSetRequest#builder()}
     * </p>
     *
     * @param createStackSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(Consumer<CreateStackSetRequest.Builder> createStackSetRequest) {
        return createStackSet(CreateStackSetRequest.builder().applyMutation(createStackSetRequest).build());
    }

    /**
     * <p>
     * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not
     * have permissions to create and manage service-managed StackSets for your organization.
     * </p>
     *
     * @param deactivateOrganizationsAccessRequest
     * @return A Java Future containing the result of the DeactivateOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeactivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateOrganizationsAccessResponse> deactivateOrganizationsAccess(
            DeactivateOrganizationsAccessRequest deactivateOrganizationsAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not
     * have permissions to create and manage service-managed StackSets for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link DeactivateOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param deactivateOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeactivateOrganizationsAccessRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeactivateOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeactivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateOrganizationsAccessResponse> deactivateOrganizationsAccess(
            Consumer<DeactivateOrganizationsAccessRequest.Builder> deactivateOrganizationsAccessRequest) {
        return deactivateOrganizationsAccess(DeactivateOrganizationsAccessRequest.builder()
                .applyMutation(deactivateOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Deactivates a public third-party extension, such as a resource or module, or a CloudFormation Hook when you no
     * longer use it.
     * </p>
     * <p>
     * Deactivating an extension deletes the configuration details that are associated with it. To temporarily disable a
     * CloudFormation Hook instead, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a>.
     * </p>
     * <p>
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     * </p>
     * <p>
     * To see which extensions are currently activated, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html">ListTypes</a>.
     * </p>
     *
     * @param deactivateTypeRequest
     * @return A Java Future containing the result of the DeactivateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeactivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeactivateTypeResponse> deactivateType(DeactivateTypeRequest deactivateTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates a public third-party extension, such as a resource or module, or a CloudFormation Hook when you no
     * longer use it.
     * </p>
     * <p>
     * Deactivating an extension deletes the configuration details that are associated with it. To temporarily disable a
     * CloudFormation Hook instead, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a>.
     * </p>
     * <p>
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     * </p>
     * <p>
     * To see which extensions are currently activated, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html">ListTypes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeactivateTypeRequest#builder()}
     * </p>
     *
     * @param deactivateTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeactivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeactivateTypeResponse> deactivateType(Consumer<DeactivateTypeRequest.Builder> deactivateTypeRequest) {
        return deactivateType(DeactivateTypeRequest.builder().applyMutation(deactivateTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteChangeSetRequest#builder()}
     * </p>
     *
     * @param deleteChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest.Builder} to create a
     *        request. The input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(
            Consumer<DeleteChangeSetRequest.Builder> deleteChangeSetRequest) {
        return deleteChangeSet(DeleteChangeSetRequest.builder().applyMutation(deleteChangeSetRequest).build());
    }

    /**
     * <p>
     * Deleted a generated template.
     * </p>
     *
     * @param deleteGeneratedTemplateRequest
     * @return A Java Future containing the result of the DeleteGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>ConcurrentResourcesLimitExceededException No more than 5 generated templates can be in an
     *         <code>InProgress</code> or <code>Pending</code> status at one time. This error is also returned if a
     *         generated template that is in an <code>InProgress</code> or <code>Pending</code> status is attempted to
     *         be updated or deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGeneratedTemplateResponse> deleteGeneratedTemplate(
            DeleteGeneratedTemplateRequest deleteGeneratedTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deleted a generated template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGeneratedTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteGeneratedTemplateRequest#builder()}
     * </p>
     *
     * @param deleteGeneratedTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeleteGeneratedTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>ConcurrentResourcesLimitExceededException No more than 5 generated templates can be in an
     *         <code>InProgress</code> or <code>Pending</code> status at one time. This error is also returned if a
     *         generated template that is in an <code>InProgress</code> or <code>Pending</code> status is attempted to
     *         be updated or deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGeneratedTemplateResponse> deleteGeneratedTemplate(
            Consumer<DeleteGeneratedTemplateRequest.Builder> deleteGeneratedTemplateRequest) {
        return deleteGeneratedTemplate(DeleteGeneratedTemplateRequest.builder().applyMutation(deleteGeneratedTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show
     * up in the <a>DescribeStacks</a> operation if the deletion has been completed successfully.
     * </p>
     * <p>
     * For more information about deleting a stack, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-console-delete-stack.html">Delete a
     * stack from the CloudFormation console</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show
     * up in the <a>DescribeStacks</a> operation if the deletion has been completed successfully.
     * </p>
     * <p>
     * For more information about deleting a stack, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-console-delete-stack.html">Delete a
     * stack from the CloudFormation console</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest.Builder} to create a
     *        request. The input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest) {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>DeleteStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteStackInstancesRequest
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            DeleteStackInstancesRequest deleteStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>DeleteStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStackInstancesRequest#builder()}
     * </p>
     *
     * @param deleteStackInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            Consumer<DeleteStackInstancesRequest.Builder> deleteStackInstancesRequest) {
        return deleteStackInstances(DeleteStackInstancesRequest.builder().applyMutation(deleteStackInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes a StackSet. Before you can delete a StackSet, all its member stack instances must be deleted. For more
     * information about how to complete this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this StackSet, because it still contains one or more
     *         stack instances. Delete all stack instances from the StackSet before deleting the StackSet.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a StackSet. Before you can delete a StackSet, all its member stack instances must be deleted. For more
     * information about how to complete this, see <a>DeleteStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackSetRequest#builder()}
     * </p>
     *
     * @param deleteStackSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this StackSet, because it still contains one or more
     *         stack instances. Delete all stack instances from the StackSet before deleting the StackSet.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(Consumer<DeleteStackSetRequest.Builder> deleteStackSetRequest) {
        return deleteStackSet(DeleteStackSetRequest.builder().applyMutation(deleteStackSetRequest).build());
    }

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You can't deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the extension type itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private-deregister-extension.html"
     * >Remove third-party private extensions from your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param deregisterTypeRequest
     * @return A Java Future containing the result of the DeregisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeregisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTypeResponse> deregisterType(DeregisterTypeRequest deregisterTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You can't deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the extension type itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private-deregister-extension.html"
     * >Remove third-party private extensions from your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeregisterTypeRequest#builder()}
     * </p>
     *
     * @param deregisterTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeregisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTypeResponse> deregisterType(Consumer<DeregisterTypeRequest.Builder> deregisterTypeRequest) {
        return deregisterType(DeregisterTypeRequest.builder().applyMutation(deregisterTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Understand
     * CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Understand
     * CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request. The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Understand
     * CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits() {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator() {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        return new DescribeAccountLimitsPublisher(this, describeAccountLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request. The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Update CloudFormation stacks using change sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Update CloudFormation stacks using change sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest.Builder} to create a
     *        request. The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return describeChangeSet(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns Hook-related information for the change set and a list of changes that CloudFormation makes when you run
     * the change set.
     * </p>
     *
     * @param describeChangeSetHooksRequest
     * @return A Java Future containing the result of the DescribeChangeSetHooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSetHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetHooksResponse> describeChangeSetHooks(
            DescribeChangeSetHooksRequest describeChangeSetHooksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Hook-related information for the change set and a list of changes that CloudFormation makes when you run
     * the change set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetHooksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeChangeSetHooksRequest#builder()}
     * </p>
     *
     * @param describeChangeSetHooksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeChangeSetHooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSetHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetHooksResponse> describeChangeSetHooks(
            Consumer<DescribeChangeSetHooksRequest.Builder> describeChangeSetHooksRequest) {
        return describeChangeSetHooks(DescribeChangeSetHooksRequest.builder().applyMutation(describeChangeSetHooksRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChangeSet(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeChangeSetPublisher publisher = client.describeChangeSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeChangeSetPublisher publisher = client.describeChangeSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChangeSet(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetPublisher describeChangeSetPaginator(DescribeChangeSetRequest describeChangeSetRequest) {
        return new DescribeChangeSetPublisher(this, describeChangeSetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChangeSet(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeChangeSetPublisher publisher = client.describeChangeSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeChangeSetPublisher publisher = client.describeChangeSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChangeSet(software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest.Builder} to create a
     *        request. The input for the <a>DescribeChangeSet</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetPublisher describeChangeSetPaginator(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return describeChangeSetPaginator(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns CloudFormation events based on flexible query criteria. Groups events by operation ID, enabling you to
     * focus on individual stack operations during deployment.
     * </p>
     * <p>
     * An operation is any action performed on a stack, including stack lifecycle actions (Create, Update, Delete,
     * Rollback), change set creation, nested stack creation, and automatic rollbacks triggered by failures. Each
     * operation has a unique identifier (Operation ID) and represents a discrete change attempt on the stack.
     * </p>
     * <p>
     * Returns different types of events including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Progress events</b> - Status updates during stack operation execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Validation errors</b> - Failures from CloudFormation Early Validations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Provisioning errors</b> - Resource creation and update failures.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Hook invocation errors</b> - Failures from CloudFormation Hook during stack operations.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * One of <code>ChangeSetName</code>, <code>OperationId</code> or <code>StackName</code> must be specified as input.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns CloudFormation events based on flexible query criteria. Groups events by operation ID, enabling you to
     * focus on individual stack operations during deployment.
     * </p>
     * <p>
     * An operation is any action performed on a stack, including stack lifecycle actions (Create, Update, Delete,
     * Rollback), change set creation, nested stack creation, and automatic rollbacks triggered by failures. Each
     * operation has a unique identifier (Operation ID) and represents a discrete change attempt on the stack.
     * </p>
     * <p>
     * Returns different types of events including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Progress events</b> - Status updates during stack operation execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Validation errors</b> - Failures from CloudFormation Early Validations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Provisioning errors</b> - Resource creation and update failures.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Hook invocation errors</b> - Failures from CloudFormation Hook during stack operations.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * One of <code>ChangeSetName</code>, <code>OperationId</code> or <code>StackName</code> must be specified as input.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Describes a generated template. The output includes details about the progress of the creation of a generated
     * template started by a <code>CreateGeneratedTemplate</code> API action or the update of a generated template
     * started with an <code>UpdateGeneratedTemplate</code> API action.
     * </p>
     *
     * @param describeGeneratedTemplateRequest
     * @return A Java Future containing the result of the DescribeGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGeneratedTemplateResponse> describeGeneratedTemplate(
            DescribeGeneratedTemplateRequest describeGeneratedTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a generated template. The output includes details about the progress of the creation of a generated
     * template started by a <code>CreateGeneratedTemplate</code> API action or the update of a generated template
     * started with an <code>UpdateGeneratedTemplate</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGeneratedTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGeneratedTemplateRequest#builder()}
     * </p>
     *
     * @param describeGeneratedTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeGeneratedTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGeneratedTemplateResponse> describeGeneratedTemplate(
            Consumer<DescribeGeneratedTemplateRequest.Builder> describeGeneratedTemplateRequest) {
        return describeGeneratedTemplate(DescribeGeneratedTemplateRequest.builder()
                .applyMutation(describeGeneratedTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the account's <code>OrganizationAccess</code> status. This API can be called either
     * by the management account or the delegated administrator by using the <code>CallAs</code> parameter. This API can
     * also be called without the <code>CallAs</code> parameter by the management account.
     * </p>
     *
     * @param describeOrganizationsAccessRequest
     * @return A Java Future containing the result of the DescribeOrganizationsAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationsAccessResponse> describeOrganizationsAccess(
            DescribeOrganizationsAccessRequest describeOrganizationsAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the account's <code>OrganizationAccess</code> status. This API can be called either
     * by the management account or the delegated administrator by using the <code>CallAs</code> parameter. This API can
     * also be called without the <code>CallAs</code> parameter by the management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationsAccessRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationsAccessRequest#builder()}
     * </p>
     *
     * @param describeOrganizationsAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationsAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationsAccessResponse> describeOrganizationsAccess(
            Consumer<DescribeOrganizationsAccessRequest.Builder> describeOrganizationsAccessRequest) {
        return describeOrganizationsAccess(DescribeOrganizationsAccessRequest.builder()
                .applyMutation(describeOrganizationsAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information about registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describePublisherRequest
     * @return A Java Future containing the result of the DescribePublisher operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribePublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePublisherResponse> describePublisher(DescribePublisherRequest describePublisherRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information about registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePublisherRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePublisherRequest#builder()}
     * </p>
     *
     * @param describePublisherRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePublisher operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribePublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePublisherResponse> describePublisher(
            Consumer<DescribePublisherRequest.Builder> describePublisherRequest) {
        return describePublisher(DescribePublisherRequest.builder().applyMutation(describePublisherRequest).build());
    }

    /**
     * <p>
     * Describes details of a resource scan.
     * </p>
     *
     * @param describeResourceScanRequest
     * @return A Java Future containing the result of the DescribeResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceScanResponse> describeResourceScan(
            DescribeResourceScanRequest describeResourceScanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details of a resource scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceScanRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceScanRequest#builder()}
     * </p>
     *
     * @param describeResourceScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeResourceScanRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceScanResponse> describeResourceScan(
            Consumer<DescribeResourceScanRequest.Builder> describeResourceScanRequest) {
        return describeResourceScan(DescribeResourceScanRequest.builder().applyMutation(describeResourceScanRequest).build());
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     * @return A Java Future containing the result of the DescribeStackDriftDetectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackDriftDetectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackDriftDetectionStatusResponse> describeStackDriftDetectionStatus(
            DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackDriftDetectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackDriftDetectionStatusRequest#builder()}
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeStackDriftDetectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackDriftDetectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackDriftDetectionStatusResponse> describeStackDriftDetectionStatus(
            Consumer<DescribeStackDriftDetectionStatusRequest.Builder> describeStackDriftDetectionStatusRequest) {
        return describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.builder()
                .applyMutation(describeStackDriftDetectionStatusRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            DescribeStackEventsRequest describeStackEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest.Builder} to create
     *        a request. The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) {
        return describeStackEvents(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsPublisher describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest) {
        return new DescribeStackEventsPublisher(this, describeStackEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest.Builder} to create
     *        a request. The input for <a>DescribeStackEvents</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsPublisher describeStackEventsPaginator(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) {
        return describeStackEventsPaginator(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon
     * Web Services Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific StackSet, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            DescribeStackInstanceRequest describeStackInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon
     * Web Services Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific StackSet, use <a>ListStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackInstanceRequest#builder()}
     * </p>
     *
     * @param describeStackInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            Consumer<DescribeStackInstanceRequest.Builder> describeStackInstanceRequest) {
        return describeStackInstance(DescribeStackInstanceRequest.builder().applyMutation(describeStackInstanceRequest).build());
    }

    /**
     * <p>
     * Describes the stack refactor status.
     * </p>
     *
     * @param describeStackRefactorRequest
     * @return A Java Future containing the result of the DescribeStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackRefactorNotFoundException The specified stack refactor can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackRefactorResponse> describeStackRefactor(
            DescribeStackRefactorRequest describeStackRefactorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the stack refactor status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackRefactorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackRefactorRequest#builder()}
     * </p>
     *
     * @param describeStackRefactorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackRefactorNotFoundException The specified stack refactor can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackRefactorResponse> describeStackRefactor(
            Consumer<DescribeStackRefactorRequest.Builder> describeStackRefactorRequest) {
        return describeStackRefactor(DescribeStackRefactorRequest.builder().applyMutation(describeStackRefactorRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            DescribeStackResourceRequest describeStackResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourceRequest#builder()}
     * </p>
     *
     * @param describeStackResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest.Builder} to
     *        create a request. The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            Consumer<DescribeStackResourceRequest.Builder> describeStackResourceRequest) {
        return describeStackResource(DescribeStackResourceRequest.builder().applyMutation(describeStackResourceRequest).build());
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't
     * currently support drift detection aren't checked, and so not included. For a list of resources that support drift
     * detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A Java Future containing the result of the DescribeStackResourceDrifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceDriftsResponse> describeStackResourceDrifts(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't
     * currently support drift detection aren't checked, and so not included. For a list of resources that support drift
     * detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStackResourceDrifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceDriftsResponse> describeStackResourceDrifts(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) {
        return describeStackResourceDrifts(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsPublisher describeStackResourceDriftsPaginator(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        return new DescribeStackResourceDriftsPublisher(this, describeStackResourceDriftsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsPublisher describeStackResourceDriftsPaginator(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) {
        return describeStackResourceDriftsPaginator(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, see the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            DescribeStackResourcesRequest describeStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, see the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourcesRequest#builder()}
     * </p>
     *
     * @param describeStackResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest.Builder} to
     *        create a request. The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            Consumer<DescribeStackResourcesRequest.Builder> describeStackResourcesRequest) {
        return describeStackResources(DescribeStackResourcesRequest.builder().applyMutation(describeStackResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of the specified StackSet.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note>
     *
     * @param describeStackSetRequest
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(DescribeStackSetRequest describeStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified StackSet.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStackSetRequest#builder()}
     * </p>
     *
     * @param describeStackSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(
            Consumer<DescribeStackSetRequest.Builder> describeStackSetRequest) {
        return describeStackSet(DescribeStackSetRequest.builder().applyMutation(describeStackSetRequest).build());
    }

    /**
     * <p>
     * Returns the description of the specified StackSet operation.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note>
     *
     * @param describeStackSetOperationRequest
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified StackSet operation.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStackSetOperationRequest#builder()}
     * </p>
     *
     * @param describeStackSetOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            Consumer<DescribeStackSetOperationRequest.Builder> describeStackSetOperationRequest) {
        return describeStackSetOperation(DescribeStackSetOperationRequest.builder()
                .applyMutation(describeStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created. For more information about a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the stack doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created. For more information about a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the stack doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest.Builder} to create a
     *        request. The input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created. For more information about a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the stack doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks() {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator() {
        return describeStacksPaginator(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator(DescribeStacksRequest describeStacksRequest) {
        return new DescribeStacksPublisher(this, describeStacksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest.Builder} to create a
     *        request. The input for <a>DescribeStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacksPaginator(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about an extension from the CloudFormation registry in your current account and
     * Region.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeTypeRequest
     * @return A Java Future containing the result of the DescribeType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTypeResponse> describeType(DescribeTypeRequest describeTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about an extension from the CloudFormation registry in your current account and
     * Region.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTypeRequest#builder()}
     * </p>
     *
     * @param describeTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTypeResponse> describeType(Consumer<DescribeTypeRequest.Builder> describeTypeRequest) {
        return describeType(DescribeTypeRequest.builder().applyMutation(describeTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <a>RegisterType</a>, you can then use
     * <a>DescribeTypeRegistration</a> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <a>DescribeType</a> to return detailed information about an
     * extension.
     * </p>
     *
     * @param describeTypeRegistrationRequest
     * @return A Java Future containing the result of the DescribeTypeRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeTypeRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTypeRegistrationResponse> describeTypeRegistration(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <a>RegisterType</a>, you can then use
     * <a>DescribeTypeRegistration</a> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <a>DescribeType</a> to return detailed information about an
     * extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTypeRegistrationRequest#builder()}
     * </p>
     *
     * @param describeTypeRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTypeRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeTypeRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTypeRegistrationResponse> describeTypeRegistration(
            Consumer<DescribeTypeRegistrationRequest.Builder> describeTypeRegistrationRequest) {
        return describeTypeRegistration(DescribeTypeRegistrationRequest.builder().applyMutation(describeTypeRegistrationRequest)
                .build());
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     *
     * @param detectStackDriftRequest
     * @return A Java Future containing the result of the DetectStackDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackDriftResponse> detectStackDrift(DetectStackDriftRequest detectStackDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackDriftRequest.Builder} avoiding the need
     * to create one manually via {@link DetectStackDriftRequest#builder()}
     * </p>
     *
     * @param detectStackDriftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectStackDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackDriftResponse> detectStackDrift(
            Consumer<DetectStackDriftRequest.Builder> detectStackDriftRequest) {
        return detectStackDrift(DetectStackDriftRequest.builder().applyMutation(detectStackDriftRequest).build());
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from its
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     *
     * @param detectStackResourceDriftRequest
     * @return A Java Future containing the result of the DetectStackResourceDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackResourceDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackResourceDriftResponse> detectStackResourceDrift(
            DetectStackResourceDriftRequest detectStackResourceDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from its
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackResourceDriftRequest.Builder} avoiding
     * the need to create one manually via {@link DetectStackResourceDriftRequest#builder()}
     * </p>
     *
     * @param detectStackResourceDriftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DetectStackResourceDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackResourceDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackResourceDriftResponse> detectStackResourceDrift(
            Consumer<DetectStackResourceDriftRequest.Builder> detectStackResourceDriftRequest) {
        return detectStackResourceDrift(DetectStackResourceDriftRequest.builder().applyMutation(detectStackResourceDriftRequest)
                .build());
    }

    /**
     * <p>
     * Detect drift on a StackSet. When CloudFormation performs drift detection on a StackSet, it performs drift
     * detection on the stack associated with each stack instance in the StackSet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Performing drift
     * detection on CloudFormation StackSets</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the StackSet drift detection operation.
     * Use this operation id with <a>DescribeStackSetOperation</a> to monitor the progress of the drift detection
     * operation. The drift detection operation may take some time, depending on the number of stack instances included
     * in the StackSet, in addition to the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a>DescribeStackSet</a> to return detailed information about the stack set, including detailed information
     * about the last <i>completed</i> drift operation performed on the StackSet. (Information about drift operations
     * that are in progress isn't included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>ListStackInstances</a> to return a list of stack instances belonging to the StackSet, including the drift
     * status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>DescribeStackInstance</a> to return detailed information about a specific stack instance, including its
     * drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can only run a single drift detection operation on a given StackSet at one time.
     * </p>
     * <p>
     * To stop a drift detection StackSet operation, use <a>StopStackSetOperation</a>.
     * </p>
     *
     * @param detectStackSetDriftRequest
     * @return A Java Future containing the result of the DetectStackSetDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackSetDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackSetDriftResponse> detectStackSetDrift(
            DetectStackSetDriftRequest detectStackSetDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detect drift on a StackSet. When CloudFormation performs drift detection on a StackSet, it performs drift
     * detection on the stack associated with each stack instance in the StackSet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Performing drift
     * detection on CloudFormation StackSets</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the StackSet drift detection operation.
     * Use this operation id with <a>DescribeStackSetOperation</a> to monitor the progress of the drift detection
     * operation. The drift detection operation may take some time, depending on the number of stack instances included
     * in the StackSet, in addition to the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a>DescribeStackSet</a> to return detailed information about the stack set, including detailed information
     * about the last <i>completed</i> drift operation performed on the StackSet. (Information about drift operations
     * that are in progress isn't included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>ListStackInstances</a> to return a list of stack instances belonging to the StackSet, including the drift
     * status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>DescribeStackInstance</a> to return detailed information about a specific stack instance, including its
     * drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can only run a single drift detection operation on a given StackSet at one time.
     * </p>
     * <p>
     * To stop a drift detection StackSet operation, use <a>StopStackSetOperation</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackSetDriftRequest.Builder} avoiding the
     * need to create one manually via {@link DetectStackSetDriftRequest#builder()}
     * </p>
     *
     * @param detectStackSetDriftRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DetectStackSetDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackSetDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackSetDriftResponse> detectStackSetDrift(
            Consumer<DetectStackSetDriftRequest.Builder> detectStackSetDriftRequest) {
        return detectStackSetDrift(DetectStackSetDriftRequest.builder().applyMutation(detectStackSetDriftRequest).build());
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            EstimateTemplateCostRequest estimateTemplateCostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EstimateTemplateCostRequest.Builder} avoiding the
     * need to create one manually via {@link EstimateTemplateCostRequest#builder()}
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest.Builder} to create
     *        a request. The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            Consumer<EstimateTemplateCostRequest.Builder> estimateTemplateCostRequest) {
        return estimateTemplateCost(EstimateTemplateCostRequest.builder().applyMutation(estimateTemplateCostRequest).build());
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteChangeSetRequest#builder()}
     * </p>
     *
     * @param executeChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest.Builder} to create a
     *        request. The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(
            Consumer<ExecuteChangeSetRequest.Builder> executeChangeSetRequest) {
        return executeChangeSet(ExecuteChangeSetRequest.builder().applyMutation(executeChangeSetRequest).build());
    }

    /**
     * <p>
     * Executes the stack refactor operation.
     * </p>
     *
     * @param executeStackRefactorRequest
     * @return A Java Future containing the result of the ExecuteStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteStackRefactorResponse> executeStackRefactor(
            ExecuteStackRefactorRequest executeStackRefactorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes the stack refactor operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteStackRefactorRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteStackRefactorRequest#builder()}
     * </p>
     *
     * @param executeStackRefactorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ExecuteStackRefactorRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ExecuteStackRefactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteStackRefactorResponse> executeStackRefactor(
            Consumer<ExecuteStackRefactorRequest.Builder> executeStackRefactorRequest) {
        return executeStackRefactor(ExecuteStackRefactorRequest.builder().applyMutation(executeStackRefactorRequest).build());
    }

    /**
     * <p>
     * Retrieves a generated template. If the template is in an <code>InProgress</code> or <code>Pending</code> status
     * then the template returned will be the template when the template was last in a <code>Complete</code> status. If
     * the template has not yet been in a <code>Complete</code> status then an empty template will be returned.
     * </p>
     *
     * @param getGeneratedTemplateRequest
     * @return A Java Future containing the result of the GetGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedTemplateResponse> getGeneratedTemplate(
            GetGeneratedTemplateRequest getGeneratedTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a generated template. If the template is in an <code>InProgress</code> or <code>Pending</code> status
     * then the template returned will be the template when the template was last in a <code>Complete</code> status. If
     * the template has not yet been in a <code>Complete</code> status then an empty template will be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeneratedTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetGeneratedTemplateRequest#builder()}
     * </p>
     *
     * @param getGeneratedTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.GetGeneratedTemplateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedTemplateResponse> getGeneratedTemplate(
            Consumer<GetGeneratedTemplateRequest.Builder> getGeneratedTemplateRequest) {
        return getGeneratedTemplate(GetGeneratedTemplateRequest.builder().applyMutation(getGeneratedTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information and remediation guidance for a Hook invocation result.
     * </p>
     * <p>
     * If the Hook uses a KMS key to encrypt annotations, callers of the <code>GetHookResult</code> operation must have
     * <code>kms:Decrypt</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-kms-key-policy.html">KMS key
     * policy and permissions for encrypting CloudFormation Hooks results at rest</a> in the <i>CloudFormation Hooks
     * User Guide</i>.
     * </p>
     *
     * @param getHookResultRequest
     * @return A Java Future containing the result of the GetHookResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HookResultNotFoundException The specified target doesn't have any requested Hook invocations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetHookResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetHookResult" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHookResultResponse> getHookResult(GetHookResultRequest getHookResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information and remediation guidance for a Hook invocation result.
     * </p>
     * <p>
     * If the Hook uses a KMS key to encrypt annotations, callers of the <code>GetHookResult</code> operation must have
     * <code>kms:Decrypt</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-kms-key-policy.html">KMS key
     * policy and permissions for encrypting CloudFormation Hooks results at rest</a> in the <i>CloudFormation Hooks
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHookResultRequest.Builder} avoiding the need to
     * create one manually via {@link GetHookResultRequest#builder()}
     * </p>
     *
     * @param getHookResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.GetHookResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetHookResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HookResultNotFoundException The specified target doesn't have any requested Hook invocations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetHookResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetHookResult" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHookResultResponse> getHookResult(Consumer<GetHookResultRequest.Builder> getHookResultRequest) {
        return getHookResult(GetHookResultRequest.builder().applyMutation(getHookResultRequest).build());
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetStackPolicyRequest#builder()}
     * </p>
     *
     * @param getStackPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest.Builder} to create a
     *        request. The input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(Consumer<GetStackPolicyRequest.Builder> getStackPolicyRequest) {
        return getStackPolicy(GetStackPolicyRequest.builder().applyMutation(getStackPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplate</code> returns the template for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <note>
     * <p>
     * If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplate</code> returns the template for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <note>
     * <p>
     * If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest.Builder} to create a
     *        request. The input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or StackSet.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a StackSet, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or StackSet.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a StackSet, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSummaryRequest#builder()}
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest.Builder} to create a
     *        request. The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(
            Consumer<GetTemplateSummaryRequest.Builder> getTemplateSummaryRequest) {
        return getTemplateSummary(GetTemplateSummaryRequest.builder().applyMutation(getTemplateSummaryRequest).build());
    }

    /**
     * <p>
     * Import existing stacks into a new StackSets. Use the stack import operation to import up to 10 stacks into a new
     * StackSet in the same account as the source stack or in a different administrator account and Region, by
     * specifying the stack ID of the stack you intend to import.
     * </p>
     *
     * @param importStacksToStackSetRequest
     * @return A Java Future containing the result of the ImportStacksToStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StackNotFoundException The specified stack ARN doesn't exist or stack doesn't exist corresponding to
     *         the ARN in input.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ImportStacksToStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportStacksToStackSetResponse> importStacksToStackSet(
            ImportStacksToStackSetRequest importStacksToStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import existing stacks into a new StackSets. Use the stack import operation to import up to 10 stacks into a new
     * StackSet in the same account as the source stack or in a different administrator account and Region, by
     * specifying the stack ID of the stack you intend to import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportStacksToStackSetRequest.Builder} avoiding the
     * need to create one manually via {@link ImportStacksToStackSetRequest#builder()}
     * </p>
     *
     * @param importStacksToStackSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ImportStacksToStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StackNotFoundException The specified stack ARN doesn't exist or stack doesn't exist corresponding to
     *         the ARN in input.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ImportStacksToStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportStacksToStackSetResponse> importStacksToStackSet(
            Consumer<ImportStacksToStackSetRequest.Builder> importStacksToStackSetRequest) {
        return importStacksToStackSet(ImportStacksToStackSetRequest.builder().applyMutation(importStacksToStackSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest.Builder} to create a
     *        request. The input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSets(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest) {
        return new ListChangeSetsPublisher(this, listChangeSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest.Builder} to create a
     *        request. The input for the <a>ListChangeSets</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSetsPaginator(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html"
     * > Fn::ImportValue</a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">Get exported
     * outputs from a deployed CloudFormation stack</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html"
     * > Fn::ImportValue</a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">Get exported
     * outputs from a deployed CloudFormation stack</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListExportsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html"
     * > Fn::ImportValue</a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">Get exported
     * outputs from a deployed CloudFormation stack</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports() {
        return listExports(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator() {
        return listExportsPaginator(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, listExportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListExportsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists your generated templates in this Region.
     * </p>
     *
     * @param listGeneratedTemplatesRequest
     * @return A Java Future containing the result of the ListGeneratedTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListGeneratedTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeneratedTemplatesResponse> listGeneratedTemplates(
            ListGeneratedTemplatesRequest listGeneratedTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your generated templates in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedTemplatesRequest#builder()}
     * </p>
     *
     * @param listGeneratedTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGeneratedTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListGeneratedTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeneratedTemplatesResponse> listGeneratedTemplates(
            Consumer<ListGeneratedTemplatesRequest.Builder> listGeneratedTemplatesRequest) {
        return listGeneratedTemplates(ListGeneratedTemplatesRequest.builder().applyMutation(listGeneratedTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGeneratedTemplates(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListGeneratedTemplatesPublisher publisher = client.listGeneratedTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListGeneratedTemplatesPublisher publisher = client.listGeneratedTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedTemplates(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGeneratedTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListGeneratedTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedTemplatesPublisher listGeneratedTemplatesPaginator(
            ListGeneratedTemplatesRequest listGeneratedTemplatesRequest) {
        return new ListGeneratedTemplatesPublisher(this, listGeneratedTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGeneratedTemplates(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListGeneratedTemplatesPublisher publisher = client.listGeneratedTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListGeneratedTemplatesPublisher publisher = client.listGeneratedTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedTemplates(software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedTemplatesRequest#builder()}
     * </p>
     *
     * @param listGeneratedTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListGeneratedTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedTemplatesPublisher listGeneratedTemplatesPaginator(
            Consumer<ListGeneratedTemplatesRequest.Builder> listGeneratedTemplatesRequest) {
        return listGeneratedTemplatesPaginator(ListGeneratedTemplatesRequest.builder()
                .applyMutation(listGeneratedTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns summaries of invoked Hooks. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-view-invocations.html">View
     * invocation summaries for CloudFormation Hooks</a> in the <i>CloudFormation Hooks User Guide</i>.
     * </p>
     * <p>
     * This operation supports the following parameter combinations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No parameters: Returns all Hook invocation summaries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypeArn</code> only: Returns summaries for a specific Hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypeArn</code> and <code>Status</code>: Returns summaries for a specific Hook filtered by status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetId</code> and <code>TargetType</code>: Returns summaries for a specific Hook invocation target.
     * </p>
     * </li>
     * </ul>
     *
     * @param listHookResultsRequest
     * @return A Java Future containing the result of the ListHookResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HookResultNotFoundException The specified target doesn't have any requested Hook invocations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListHookResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListHookResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHookResultsResponse> listHookResults(ListHookResultsRequest listHookResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of invoked Hooks. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-view-invocations.html">View
     * invocation summaries for CloudFormation Hooks</a> in the <i>CloudFormation Hooks User Guide</i>.
     * </p>
     * <p>
     * This operation supports the following parameter combinations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No parameters: Returns all Hook invocation summaries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypeArn</code> only: Returns summaries for a specific Hook.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypeArn</code> and <code>Status</code>: Returns summaries for a specific Hook filtered by status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetId</code> and <code>TargetType</code>: Returns summaries for a specific Hook invocation target.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHookResultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHookResultsRequest#builder()}
     * </p>
     *
     * @param listHookResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListHookResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListHookResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HookResultNotFoundException The specified target doesn't have any requested Hook invocations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListHookResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListHookResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHookResultsResponse> listHookResults(
            Consumer<ListHookResultsRequest.Builder> listHookResultsRequest) {
        return listHookResults(ListHookResultsRequest.builder().applyMutation(listHookResultsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html"
     * >Fn::ImportValue</a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html"
     * >Fn::ImportValue</a> function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListImportsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, listImportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListImportsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Lists the related resources for a list of resources from a resource scan. The response indicates whether each
     * returned resource is already managed by CloudFormation.
     * </p>
     *
     * @param listResourceScanRelatedResourcesRequest
     * @return A Java Future containing the result of the ListResourceScanRelatedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanRelatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScanRelatedResourcesResponse> listResourceScanRelatedResources(
            ListResourceScanRelatedResourcesRequest listResourceScanRelatedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the related resources for a list of resources from a resource scan. The response indicates whether each
     * returned resource is already managed by CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScanRelatedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceScanRelatedResourcesRequest#builder()}
     * </p>
     *
     * @param listResourceScanRelatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListResourceScanRelatedResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanRelatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScanRelatedResourcesResponse> listResourceScanRelatedResources(
            Consumer<ListResourceScanRelatedResourcesRequest.Builder> listResourceScanRelatedResourcesRequest) {
        return listResourceScanRelatedResources(ListResourceScanRelatedResourcesRequest.builder()
                .applyMutation(listResourceScanRelatedResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScanRelatedResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanRelatedResourcesPublisher publisher = client.listResourceScanRelatedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanRelatedResourcesPublisher publisher = client.listResourceScanRelatedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScanRelatedResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceScanRelatedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanRelatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScanRelatedResourcesPublisher listResourceScanRelatedResourcesPaginator(
            ListResourceScanRelatedResourcesRequest listResourceScanRelatedResourcesRequest) {
        return new ListResourceScanRelatedResourcesPublisher(this, listResourceScanRelatedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScanRelatedResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanRelatedResourcesPublisher publisher = client.listResourceScanRelatedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanRelatedResourcesPublisher publisher = client.listResourceScanRelatedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScanRelatedResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScanRelatedResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceScanRelatedResourcesRequest#builder()}
     * </p>
     *
     * @param listResourceScanRelatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanRelatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScanRelatedResourcesPublisher listResourceScanRelatedResourcesPaginator(
            Consumer<ListResourceScanRelatedResourcesRequest.Builder> listResourceScanRelatedResourcesRequest) {
        return listResourceScanRelatedResourcesPaginator(ListResourceScanRelatedResourcesRequest.builder()
                .applyMutation(listResourceScanRelatedResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type
     * prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response
     * indicates whether each returned resource is already managed by CloudFormation.
     * </p>
     *
     * @param listResourceScanResourcesRequest
     * @return A Java Future containing the result of the ListResourceScanResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScanResourcesResponse> listResourceScanResources(
            ListResourceScanResourcesRequest listResourceScanResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type
     * prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response
     * indicates whether each returned resource is already managed by CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScanResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceScanResourcesRequest#builder()}
     * </p>
     *
     * @param listResourceScanResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResourceScanResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScanResourcesResponse> listResourceScanResources(
            Consumer<ListResourceScanResourcesRequest.Builder> listResourceScanResourcesRequest) {
        return listResourceScanResources(ListResourceScanResourcesRequest.builder()
                .applyMutation(listResourceScanResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScanResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanResourcesPublisher publisher = client.listResourceScanResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanResourcesPublisher publisher = client.listResourceScanResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScanResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceScanResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScanResourcesPublisher listResourceScanResourcesPaginator(
            ListResourceScanResourcesRequest listResourceScanResourcesRequest) {
        return new ListResourceScanResourcesPublisher(this, listResourceScanResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScanResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanResourcesPublisher publisher = client.listResourceScanResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScanResourcesPublisher publisher = client.listResourceScanResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScanResources(software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScanResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceScanResourcesRequest#builder()}
     * </p>
     *
     * @param listResourceScanResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanNotFoundException The resource scan was not found.</li>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScanResourcesPublisher listResourceScanResourcesPaginator(
            Consumer<ListResourceScanResourcesRequest.Builder> listResourceScanResourcesRequest) {
        return listResourceScanResourcesPaginator(ListResourceScanResourcesRequest.builder()
                .applyMutation(listResourceScanResourcesRequest).build());
    }

    /**
     * <p>
     * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
     * </p>
     *
     * @param listResourceScansRequest
     * @return A Java Future containing the result of the ListResourceScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScansResponse> listResourceScans(ListResourceScansRequest listResourceScansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScansRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceScansRequest#builder()}
     * </p>
     *
     * @param listResourceScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceScansResponse> listResourceScans(
            Consumer<ListResourceScansRequest.Builder> listResourceScansRequest) {
        return listResourceScans(ListResourceScansRequest.builder().applyMutation(listResourceScansRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScans(software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScansPublisher publisher = client.listResourceScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScansPublisher publisher = client.listResourceScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScans(software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceScansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScansPublisher listResourceScansPaginator(ListResourceScansRequest listResourceScansRequest) {
        return new ListResourceScansPublisher(this, listResourceScansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceScans(software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScansPublisher publisher = client.listResourceScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListResourceScansPublisher publisher = client.listResourceScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceScans(software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceScansRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceScansRequest#builder()}
     * </p>
     *
     * @param listResourceScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListResourceScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceScansPublisher listResourceScansPaginator(
            Consumer<ListResourceScansRequest.Builder> listResourceScansRequest) {
        return listResourceScansPaginator(ListResourceScansRequest.builder().applyMutation(listResourceScansRequest).build());
    }

    /**
     * <p>
     * Returns drift information for resources in a stack instance.
     * </p>
     * <note>
     * <p>
     * <code>ListStackInstanceResourceDrifts</code> returns drift information for the most recent drift detection
     * operation. If an operation is in progress, it may only return partial results.
     * </p>
     * </note>
     *
     * @param listStackInstanceResourceDriftsRequest
     * @return A Java Future containing the result of the ListStackInstanceResourceDrifts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstanceResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstanceResourceDriftsResponse> listStackInstanceResourceDrifts(
            ListStackInstanceResourceDriftsRequest listStackInstanceResourceDriftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for resources in a stack instance.
     * </p>
     * <note>
     * <p>
     * <code>ListStackInstanceResourceDrifts</code> returns drift information for the most recent drift detection
     * operation. If an operation is in progress, it may only return partial results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstanceResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackInstanceResourceDriftsRequest#builder()}
     * </p>
     *
     * @param listStackInstanceResourceDriftsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStackInstanceResourceDrifts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstanceResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstanceResourceDriftsResponse> listStackInstanceResourceDrifts(
            Consumer<ListStackInstanceResourceDriftsRequest.Builder> listStackInstanceResourceDriftsRequest) {
        return listStackInstanceResourceDrifts(ListStackInstanceResourceDriftsRequest.builder()
                .applyMutation(listStackInstanceResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified StackSet. You can filter
     * for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have
     * a specific status.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(ListStackInstancesRequest listStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified StackSet. You can filter
     * for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have
     * a specific status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) {
        return listStackInstances(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesPublisher listStackInstancesPaginator(ListStackInstancesRequest listStackInstancesRequest) {
        return new ListStackInstancesPublisher(this, listStackInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesPublisher listStackInstancesPaginator(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) {
        return listStackInstancesPaginator(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the stack refactor actions that will be taken after calling the <a>ExecuteStackRefactor</a> action.
     * </p>
     *
     * @param listStackRefactorActionsRequest
     * @return A Java Future containing the result of the ListStackRefactorActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactorActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactorActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackRefactorActionsResponse> listStackRefactorActions(
            ListStackRefactorActionsRequest listStackRefactorActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stack refactor actions that will be taken after calling the <a>ExecuteStackRefactor</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackRefactorActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStackRefactorActionsRequest#builder()}
     * </p>
     *
     * @param listStackRefactorActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListStackRefactorActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactorActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactorActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackRefactorActionsResponse> listStackRefactorActions(
            Consumer<ListStackRefactorActionsRequest.Builder> listStackRefactorActionsRequest) {
        return listStackRefactorActions(ListStackRefactorActionsRequest.builder().applyMutation(listStackRefactorActionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackRefactorActions(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorActionsPublisher publisher = client.listStackRefactorActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorActionsPublisher publisher = client.listStackRefactorActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackRefactorActions(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackRefactorActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactorActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactorActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackRefactorActionsPublisher listStackRefactorActionsPaginator(
            ListStackRefactorActionsRequest listStackRefactorActionsRequest) {
        return new ListStackRefactorActionsPublisher(this, listStackRefactorActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackRefactorActions(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorActionsPublisher publisher = client.listStackRefactorActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorActionsPublisher publisher = client.listStackRefactorActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackRefactorActions(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackRefactorActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStackRefactorActionsRequest#builder()}
     * </p>
     *
     * @param listStackRefactorActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactorActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactorActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackRefactorActionsPublisher listStackRefactorActionsPaginator(
            Consumer<ListStackRefactorActionsRequest.Builder> listStackRefactorActionsRequest) {
        return listStackRefactorActionsPaginator(ListStackRefactorActionsRequest.builder()
                .applyMutation(listStackRefactorActionsRequest).build());
    }

    /**
     * <p>
     * Lists all account stack refactor operations and their statuses.
     * </p>
     *
     * @param listStackRefactorsRequest
     * @return A Java Future containing the result of the ListStackRefactors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackRefactorsResponse> listStackRefactors(ListStackRefactorsRequest listStackRefactorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account stack refactor operations and their statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackRefactorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackRefactorsRequest#builder()}
     * </p>
     *
     * @param listStackRefactorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStackRefactors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackRefactorsResponse> listStackRefactors(
            Consumer<ListStackRefactorsRequest.Builder> listStackRefactorsRequest) {
        return listStackRefactors(ListStackRefactorsRequest.builder().applyMutation(listStackRefactorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackRefactors(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorsPublisher publisher = client.listStackRefactorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorsPublisher publisher = client.listStackRefactorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackRefactors(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackRefactorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackRefactorsPublisher listStackRefactorsPaginator(ListStackRefactorsRequest listStackRefactorsRequest) {
        return new ListStackRefactorsPublisher(this, listStackRefactorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackRefactors(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorsPublisher publisher = client.listStackRefactorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackRefactorsPublisher publisher = client.listStackRefactorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackRefactors(software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackRefactorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackRefactorsRequest#builder()}
     * </p>
     *
     * @param listStackRefactorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackRefactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackRefactorsPublisher listStackRefactorsPaginator(
            Consumer<ListStackRefactorsRequest.Builder> listStackRefactorsRequest) {
        return listStackRefactorsPaginator(ListStackRefactorsRequest.builder().applyMutation(listStackRefactorsRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest.Builder} to create a
     *        request. The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) {
        return listStackResources(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesPublisher listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest) {
        return new ListStackResourcesPublisher(this, listStackResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest.Builder} to create a
     *        request. The input for the <a>ListStackResource</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesPublisher listStackResourcesPaginator(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) {
        return listStackResourcesPaginator(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about deployment targets for a StackSet.
     * </p>
     *
     * @param listStackSetAutoDeploymentTargetsRequest
     * @return A Java Future containing the result of the ListStackSetAutoDeploymentTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetAutoDeploymentTargets
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetAutoDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetAutoDeploymentTargetsResponse> listStackSetAutoDeploymentTargets(
            ListStackSetAutoDeploymentTargetsRequest listStackSetAutoDeploymentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about deployment targets for a StackSet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetAutoDeploymentTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetAutoDeploymentTargetsRequest#builder()}
     * </p>
     *
     * @param listStackSetAutoDeploymentTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetAutoDeploymentTargetsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStackSetAutoDeploymentTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetAutoDeploymentTargets
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetAutoDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetAutoDeploymentTargetsResponse> listStackSetAutoDeploymentTargets(
            Consumer<ListStackSetAutoDeploymentTargetsRequest.Builder> listStackSetAutoDeploymentTargetsRequest) {
        return listStackSetAutoDeploymentTargets(ListStackSetAutoDeploymentTargetsRequest.builder()
                .applyMutation(listStackSetAutoDeploymentTargetsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a StackSet operation.
     * </p>
     * <note>
     * <p>
     * This API provides <i>eventually consistent</i> reads meaning it may take some time but will eventually return the
     * most up-to-date data.
     * </p>
     * </note>
     *
     * @param listStackSetOperationResultsRequest
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a StackSet operation.
     * </p>
     * <note>
     * <p>
     * This API provides <i>eventually consistent</i> reads meaning it may take some time but will eventually return the
     * most up-to-date data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest) {
        return listStackSetOperationResults(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsPublisher listStackSetOperationResultsPaginator(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        return new ListStackSetOperationResultsPublisher(this, listStackSetOperationResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsPublisher listStackSetOperationResultsPaginator(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest) {
        return listStackSetOperationResultsPaginator(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a StackSet.
     * </p>
     * <note>
     * <p>
     * This API provides <i>eventually consistent</i> reads meaning it may take some time but will eventually return the
     * most up-to-date data.
     * </p>
     * </note>
     *
     * @param listStackSetOperationsRequest
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a StackSet.
     * </p>
     * <note>
     * <p>
     * This API provides <i>eventually consistent</i> reads meaning it may take some time but will eventually return the
     * most up-to-date data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) {
        return listStackSetOperations(ListStackSetOperationsRequest.builder().applyMutation(listStackSetOperationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsPublisher listStackSetOperationsPaginator(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        return new ListStackSetOperationsPublisher(this, listStackSetOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsPublisher listStackSetOperationsPaginator(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) {
        return listStackSetOperationsPaginator(ListStackSetOperationsRequest.builder()
                .applyMutation(listStackSetOperationsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about StackSets that are associated with the user.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed StackSets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all StackSets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all StackSets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     *
     * @param listStackSetsRequest
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(ListStackSetsRequest listStackSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about StackSets that are associated with the user.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed StackSets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all StackSets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all StackSets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest) {
        return listStackSets(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about StackSets that are associated with the user.
     * </p>
     * <note>
     * <p>
     * This API provides <i>strongly consistent</i> reads meaning it will always return the most up-to-date data.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed StackSets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all StackSets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all StackSets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets() {
        return listStackSets(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator() {
        return listStackSetsPaginator(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @param listStackSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator(ListStackSetsRequest listStackSetsRequest) {
        return new ListStackSetsPublisher(this, listStackSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest) {
        return listStackSetsPaginator(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified <code>StackStatusFilter</code>.
     * Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * <code>StackStatusFilter</code> is specified, summary information for all stacks is returned (including existing
     * stacks and stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(ListStacksRequest listStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified <code>StackStatusFilter</code>.
     * Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * <code>StackStatusFilter</code> is specified, summary information for all stacks is returned (including existing
     * stacks and stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStacksRequest.Builder} to create a
     *        request. The input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(Consumer<ListStacksRequest.Builder> listStacksRequest) {
        return listStacks(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified <code>StackStatusFilter</code>.
     * Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * <code>StackStatusFilter</code> is specified, summary information for all stacks is returned (including existing
     * stacks and stacks that have been deleted).
     * </p>
     *
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks() {
        return listStacks(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator() {
        return listStacksPaginator(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator(ListStacksRequest listStacksRequest) {
        return new ListStacksPublisher(this, listStacksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListStacksRequest.Builder} to create a
     *        request. The input for <a>ListStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator(Consumer<ListStacksRequest.Builder> listStacksRequest) {
        return listStacksPaginator(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A Java Future containing the result of the ListTypeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeRegistrationsResponse> listTypeRegistrations(
            ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTypeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeRegistrationsResponse> listTypeRegistrations(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) {
        return listTypeRegistrations(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsPublisher listTypeRegistrationsPaginator(
            ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        return new ListTypeRegistrationsPublisher(this, listTypeRegistrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsPublisher listTypeRegistrationsPaginator(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) {
        return listTypeRegistrationsPaginator(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A Java Future containing the result of the ListTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeVersionsResponse> listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeVersionsResponse> listTypeVersions(
            Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest) {
        return listTypeVersions(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsPublisher listTypeVersionsPaginator(ListTypeVersionsRequest listTypeVersionsRequest) {
        return new ListTypeVersionsPublisher(this, listTypeVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsPublisher listTypeVersionsPaginator(Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest) {
        return listTypeVersionsPaginator(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about all extensions, including your private resource types, modules, and Hooks as
     * well as all public extensions from Amazon Web Services and third-party publishers.
     * </p>
     *
     * @param listTypesRequest
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(ListTypesRequest listTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about all extensions, including your private resource types, modules, and Hooks as
     * well as all public extensions from Amazon Web Services and third-party publishers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(Consumer<ListTypesRequest.Builder> listTypesRequest) {
        return listTypes(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     *
     * @param listTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesPublisher listTypesPaginator(ListTypesRequest listTypesRequest) {
        return new ListTypesPublisher(this, listTypesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ListTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesPublisher listTypesPaginator(Consumer<ListTypesRequest.Builder> listTypesRequest) {
        return listTypesPaginator(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public
     * extensions are available for use by all CloudFormation users. For more information about publishing extensions,
     * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     *
     * @param publishTypeRequest
     * @return A Java Future containing the result of the PublishType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.PublishType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishTypeResponse> publishType(PublishTypeRequest publishTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public
     * extensions are available for use by all CloudFormation users. For more information about publishing extensions,
     * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PublishTypeRequest#builder()}
     * </p>
     *
     * @param publishTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PublishType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.PublishType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishTypeResponse> publishType(Consumer<PublishTypeRequest.Builder> publishTypeRequest) {
        return publishType(PublishTypeRequest.builder().applyMutation(publishTypeRequest).build());
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Don't use this API in your code.
     * </p>
     *
     * @param recordHandlerProgressRequest
     * @return A Java Future containing the result of the RecordHandlerProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidStateTransitionException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</li>
     *         <li>OperationStatusCheckFailedException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RecordHandlerProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordHandlerProgressResponse> recordHandlerProgress(
            RecordHandlerProgressRequest recordHandlerProgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Don't use this API in your code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordHandlerProgressRequest.Builder} avoiding the
     * need to create one manually via {@link RecordHandlerProgressRequest#builder()}
     * </p>
     *
     * @param recordHandlerProgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RecordHandlerProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidStateTransitionException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</li>
     *         <li>OperationStatusCheckFailedException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RecordHandlerProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordHandlerProgressResponse> recordHandlerProgress(
            Consumer<RecordHandlerProgressRequest.Builder> recordHandlerProgressRequest) {
        return recordHandlerProgress(RecordHandlerProgressRequest.builder().applyMutation(recordHandlerProgressRequest).build());
    }

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information about requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Prerequisite: Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation Command
     * Line Interface (CLI) User Guide</i>.
     * </p>
     * <p/>
     *
     * @param registerPublisherRequest
     * @return A Java Future containing the result of the RegisterPublisher operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>CloudFormationException Base class for all
     *         service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterPublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPublisherResponse> registerPublisher(RegisterPublisherRequest registerPublisherRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information about requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Prerequisite: Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation Command
     * Line Interface (CLI) User Guide</i>.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterPublisherRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterPublisherRequest#builder()}
     * </p>
     *
     * @param registerPublisherRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterPublisher operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterPublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPublisherResponse> registerPublisher(
            Consumer<RegisterPublisherRequest.Builder> registerPublisherRequest) {
        return registerPublisher(RegisterPublisherRequest.builder().applyMutation(registerPublisherRequest).build());
    }

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to develop extensions and ready them for registration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating resource
     * types using the CloudFormation CLI</a> in the <i>CloudFormation Command Line Interface (CLI) User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per Region. Use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html"
     * >DeregisterType</a> to deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <a>RegisterType</a>, you can use
     * <a>DescribeTypeRegistration</a> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param registerTypeRequest
     * @return A Java Future containing the result of the RegisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTypeResponse> registerType(RegisterTypeRequest registerTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to develop extensions and ready them for registration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating resource
     * types using the CloudFormation CLI</a> in the <i>CloudFormation Command Line Interface (CLI) User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per Region. Use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html"
     * >DeregisterType</a> to deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <a>RegisterType</a>, you can use
     * <a>DescribeTypeRegistration</a> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterTypeRequest#builder()}
     * </p>
     *
     * @param registerTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTypeResponse> registerType(Consumer<RegisterTypeRequest.Builder> registerTypeRequest) {
        return registerType(RegisterTypeRequest.builder().applyMutation(registerTypeRequest).build());
    }

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param rollbackStackRequest
     * @return A Java Future containing the result of the RollbackStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RollbackStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RollbackStackResponse> rollbackStack(RollbackStackRequest rollbackStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackStackRequest.Builder} avoiding the need to
     * create one manually via {@link RollbackStackRequest#builder()}
     * </p>
     *
     * @param rollbackStackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RollbackStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RollbackStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RollbackStackResponse> rollbackStack(Consumer<RollbackStackRequest.Builder> rollbackStackRequest) {
        return rollbackStack(RollbackStackRequest.builder().applyMutation(rollbackStackRequest).build());
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link SetStackPolicyRequest#builder()}
     * </p>
     *
     * @param setStackPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest.Builder} to create a
     *        request. The input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(Consumer<SetStackPolicyRequest.Builder> setStackPolicyRequest) {
        return setStackPolicy(SetStackPolicyRequest.builder().applyMutation(setStackPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies the configuration data for a CloudFormation extension, such as a resource or Hook, in the given account
     * and Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <important>
     * <p>
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">Specify values
     * stored in other services using dynamic references</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </important>
     * <p>
     * For more information about setting the configuration data for resource types, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
     * >Defining the account-level configuration of an extension</a> in the <i>CloudFormation Command Line Interface
     * (CLI) User Guide</i>. For more information about setting the configuration data for Hooks, see the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html"
     * >CloudFormation Hooks User Guide</a>.
     * </p>
     *
     * @param setTypeConfigurationRequest
     * @return A Java Future containing the result of the SetTypeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeConfigurationResponse> setTypeConfiguration(
            SetTypeConfigurationRequest setTypeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the configuration data for a CloudFormation extension, such as a resource or Hook, in the given account
     * and Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <important>
     * <p>
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">Specify values
     * stored in other services using dynamic references</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </important>
     * <p>
     * For more information about setting the configuration data for resource types, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
     * >Defining the account-level configuration of an extension</a> in the <i>CloudFormation Command Line Interface
     * (CLI) User Guide</i>. For more information about setting the configuration data for Hooks, see the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html"
     * >CloudFormation Hooks User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTypeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link SetTypeConfigurationRequest#builder()}
     * </p>
     *
     * @param setTypeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SetTypeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeConfigurationResponse> setTypeConfiguration(
            Consumer<SetTypeConfigurationRequest.Builder> setTypeConfigurationRequest) {
        return setTypeConfiguration(SetTypeConfigurationRequest.builder().applyMutation(setTypeConfigurationRequest).build());
    }

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     * @return A Java Future containing the result of the SetTypeDefaultVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeDefaultVersionResponse> setTypeDefaultVersion(
            SetTypeDefaultVersionRequest setTypeDefaultVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTypeDefaultVersionRequest.Builder} avoiding the
     * need to create one manually via {@link SetTypeDefaultVersionRequest#builder()}
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetTypeDefaultVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeDefaultVersionResponse> setTypeDefaultVersion(
            Consumer<SetTypeDefaultVersionRequest.Builder> setTypeDefaultVersionRequest) {
        return setTypeDefaultVersion(SetTypeDefaultVersionRequest.builder().applyMutation(setTypeDefaultVersionRequest).build());
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the
     * <code>SignalResource</code> operation in conjunction with a creation policy or update policy. CloudFormation
     * doesn't proceed with a stack creation or update until resources receive the required number of signals or the
     * timeout period is exceeded. The <code>SignalResource</code> operation is useful in cases where you want to send
     * signals from anywhere other than an Amazon EC2 instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(SignalResourceRequest signalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the
     * <code>SignalResource</code> operation in conjunction with a creation policy or update policy. CloudFormation
     * doesn't proceed with a stack creation or update until resources receive the required number of signals or the
     * timeout period is exceeded. The <code>SignalResource</code> operation is useful in cases where you want to send
     * signals from anywhere other than an Amazon EC2 instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignalResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SignalResourceRequest#builder()}
     * </p>
     *
     * @param signalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest.Builder} to create a
     *        request. The input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(Consumer<SignalResourceRequest.Builder> signalResourceRequest) {
        return signalResource(SignalResourceRequest.builder().applyMutation(signalResourceRequest).build());
    }

    /**
     * <p>
     * Starts a scan of the resources in this account in this Region. You can the status of a scan using the
     * <code>ListResourceScans</code> API action.
     * </p>
     *
     * @param startResourceScanRequest
     * @return A Java Future containing the result of the StartResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>ResourceScanLimitExceededException The limit on resource scans has been exceeded. Reasons
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Exceeded the daily quota for resource scans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A resource scan recently failed. You must wait 10 minutes before starting a new resource scan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The last resource scan failed after exceeding 100,000 resources. When this happens, you must wait 24
     *         hours before starting a new resource scan.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StartResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartResourceScanResponse> startResourceScan(StartResourceScanRequest startResourceScanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a scan of the resources in this account in this Region. You can the status of a scan using the
     * <code>ListResourceScans</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartResourceScanRequest.Builder} avoiding the need
     * to create one manually via {@link StartResourceScanRequest#builder()}
     * </p>
     *
     * @param startResourceScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.StartResourceScanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceScanInProgressException A resource scan is currently in progress. Only one can be run at a
     *         time for an account in a Region.</li>
     *         <li>ResourceScanLimitExceededException The limit on resource scans has been exceeded. Reasons
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Exceeded the daily quota for resource scans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A resource scan recently failed. You must wait 10 minutes before starting a new resource scan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The last resource scan failed after exceeding 100,000 resources. When this happens, you must wait 24
     *         hours before starting a new resource scan.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StartResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartResourceScanResponse> startResourceScan(
            Consumer<StartResourceScanRequest.Builder> startResourceScanRequest) {
        return startResourceScan(StartResourceScanRequest.builder().applyMutation(startResourceScanRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress operation on a StackSet and its associated stack instances. StackSets will cancel all the
     * unstarted stack instance deployments and wait for those are in-progress to complete.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            StopStackSetOperationRequest stopStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress operation on a StackSet and its associated stack instances. StackSets will cancel all the
     * unstarted stack instance deployments and wait for those are in-progress to complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStackSetOperationRequest.Builder} avoiding the
     * need to create one manually via {@link StopStackSetOperationRequest#builder()}
     * </p>
     *
     * @param stopStackSetOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            Consumer<StopStackSetOperationRequest.Builder> stopStackSetOperationRequest) {
        return stopStackSetOperation(StopStackSetOperationRequest.builder().applyMutation(stopStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension before publishing</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and
     * Region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can pass the returned
     * <code>TypeVersionArn</code> into <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     *
     * @param testTypeRequest
     * @return A Java Future containing the result of the TestType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.TestType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestTypeResponse> testType(TestTypeRequest testTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension before publishing</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and
     * Region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can pass the returned
     * <code>TypeVersionArn</code> into <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestTypeRequest.Builder} avoiding the need to
     * create one manually via {@link TestTypeRequest#builder()}
     * </p>
     *
     * @param testTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.TestTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified extension doesn't exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.TestType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestTypeResponse> testType(Consumer<TestTypeRequest.Builder> testTypeRequest) {
        return testType(TestTypeRequest.builder().applyMutation(testTypeRequest).build());
    }

    /**
     * <p>
     * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources,
     * and change the <code>DeletionPolicy</code> and <code>UpdateReplacePolicy</code> settings. You can check the
     * status of the update to the generated template using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     *
     * @param updateGeneratedTemplateRequest
     * @return A Java Future containing the result of the UpdateGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGeneratedTemplateResponse> updateGeneratedTemplate(
            UpdateGeneratedTemplateRequest updateGeneratedTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources,
     * and change the <code>DeletionPolicy</code> and <code>UpdateReplacePolicy</code> settings. You can check the
     * status of the update to the generated template using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGeneratedTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGeneratedTemplateRequest#builder()}
     * </p>
     *
     * @param updateGeneratedTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.UpdateGeneratedTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateGeneratedTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>GeneratedTemplateNotFoundException The generated template was not found.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGeneratedTemplateResponse> updateGeneratedTemplate(
            Consumer<UpdateGeneratedTemplateRequest.Builder> updateGeneratedTemplateRequest) {
        return updateGeneratedTemplate(UpdateGeneratedTemplateRequest.builder().applyMutation(updateGeneratedTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack through the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about updating a stack and monitoring the progress of the update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack through the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about updating a stack and monitoring the progress of the update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest.Builder} to create a
     *        request. The input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest) {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web
     * Services Regions. A stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to
     * create additional stack instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During StackSet updates, any parameters overridden for a stack instance aren't updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the StackSet. To add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the StackSet template. If you add a parameter to a template, before you can override the parameter
     * value specified in the StackSet you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>UpdateStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateStackInstancesRequest
     * @return A Java Future containing the result of the UpdateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStackInstancesResponse> updateStackInstances(
            UpdateStackInstancesRequest updateStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web
     * Services Regions. A stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to
     * create additional stack instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During StackSet updates, any parameters overridden for a stack instance aren't updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the StackSet. To add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the StackSet template. If you add a parameter to a template, before you can override the parameter
     * value specified in the StackSet you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>UpdateStackInstances</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStackInstancesRequest#builder()}
     * </p>
     *
     * @param updateStackInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStackInstancesResponse> updateStackInstances(
            Consumer<UpdateStackInstancesRequest.Builder> updateStackInstancesRequest) {
        return updateStackInstances(UpdateStackInstancesRequest.builder().applyMutation(updateStackInstancesRequest).build());
    }

    /**
     * <p>
     * Updates the StackSet and associated stack instances in the specified accounts and Amazon Web Services Regions.
     * </p>
     * <p>
     * Even if the StackSet operation created by updating the StackSet fails (completely or partially, below or above a
     * specified failure tolerance), the StackSet is updated with your changes. Subsequent <a>CreateStackInstances</a>
     * calls on the specified StackSet use the updated StackSet.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>UpdateStackSet</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateStackSetRequest
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(UpdateStackSetRequest updateStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the StackSet and associated stack instances in the specified accounts and Amazon Web Services Regions.
     * </p>
     * <p>
     * Even if the StackSet operation created by updating the StackSet fails (completely or partially, below or above a
     * specified failure tolerance), the StackSet is updated with your changes. Subsequent <a>CreateStackInstances</a>
     * calls on the specified StackSet use the updated StackSet.
     * </p>
     * <note>
     * <p>
     * The maximum number of organizational unit (OUs) supported by a <code>UpdateStackSet</code> operation is 50.
     * </p>
     * <p>
     * If you need more than 50, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Batch processing:</i> If you don't want to expose your OU hierarchy, split up the operations into multiple
     * calls with less than 50 OUs each.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Parent OU strategy:</i> If you don't mind exposing the OU hierarchy, target a parent OU that contains all
     * desired child OUs.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackSetRequest#builder()}
     * </p>
     *
     * @param updateStackSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>StackSetNotFoundException The specified StackSet doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this StackSet. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this StackSet since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(Consumer<UpdateStackSetRequest.Builder> updateStackSetRequest) {
        return updateStackSet(UpdateStackSetRequest.builder().applyMutation(updateStackSetRequest).build());
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protect a
     * CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protect a
     * CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTerminationProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTerminationProtectionRequest#builder()}
     * </p>
     *
     * @param updateTerminationProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            Consumer<UpdateTerminationProtectionRequest.Builder> updateTerminationProtectionRequest) {
        return updateTerminationProtection(UpdateTerminationProtectionRequest.builder()
                .applyMutation(updateTerminationProtectionRequest).build());
    }

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link ValidateTemplateRequest#builder()}
     * </p>
     *
     * @param validateTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest.Builder} to create a
     *        request. The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(
            Consumer<ValidateTemplateRequest.Builder> validateTemplateRequest) {
        return validateTemplate(ValidateTemplateRequest.builder().applyMutation(validateTemplateRequest).build());
    }

    /**
     * Create an instance of {@link CloudFormationAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFormationAsyncWaiter}
     */
    default CloudFormationAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default CloudFormationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudFormationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFormationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFormationAsyncClient}.
     */
    static CloudFormationAsyncClientBuilder builder() {
        return new DefaultCloudFormationAsyncClientBuilder();
    }
}
