/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceScanResourcesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListResourceScanResourcesRequest.Builder, ListResourceScanResourcesRequest> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceScanId").getter(getter(ListResourceScanResourcesRequest::resourceScanId))
            .setter(setter(Builder::resourceScanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(ListResourceScanResourcesRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceTypePrefix").getter(getter(ListResourceScanResourcesRequest::resourceTypePrefix))
            .setter(setter(Builder::resourceTypePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypePrefix").build())
            .build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(ListResourceScanResourcesRequest::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagValue").getter(getter(ListResourceScanResourcesRequest::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceScanResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceScanResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD,
            RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_PREFIX_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceScanId;

    private final String resourceIdentifier;

    private final String resourceTypePrefix;

    private final String tagKey;

    private final String tagValue;

    private final String nextToken;

    private final Integer maxResults;

    private ListResourceScanResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceTypePrefix = builder.resourceTypePrefix;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource scan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource scan.
     */
    public final String resourceScanId() {
        return resourceScanId;
    }

    /**
     * <p>
     * If specified, the returned resources will have the specified resource identifier (or one of them in the case
     * where the resource has multiple identifiers).
     * </p>
     * 
     * @return If specified, the returned resources will have the specified resource identifier (or one of them in the
     *         case where the resource has multiple identifiers).
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * If specified, the returned resources will be of any of the resource types with the specified prefix.
     * </p>
     * 
     * @return If specified, the returned resources will be of any of the resource types with the specified prefix.
     */
    public final String resourceTypePrefix() {
        return resourceTypePrefix;
    }

    /**
     * <p>
     * If specified, the returned resources will have a matching tag key.
     * </p>
     * 
     * @return If specified, the returned resources will have a matching tag key.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * If specified, the returned resources will have a matching tag value.
     * </p>
     * 
     * @return If specified, the returned resources will have a matching tag value.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value
     * that you can use for the <code>NextToken</code> parameter to get the next set of results. By default the
     * <code>ListResourceScanResources</code> API action will return at most 100 results in each response. The maximum
     * value is 100.
     * </p>
     * 
     * @return If the number of available results exceeds this maximum, the response includes a <code>NextToken</code>
     *         value that you can use for the <code>NextToken</code> parameter to get the next set of results. By
     *         default the <code>ListResourceScanResources</code> API action will return at most 100 results in each
     *         response. The maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanResourcesRequest)) {
            return false;
        }
        ListResourceScanResourcesRequest other = (ListResourceScanResourcesRequest) obj;
        return Objects.equals(resourceScanId(), other.resourceScanId())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceTypePrefix(), other.resourceTypePrefix()) && Objects.equals(tagKey(), other.tagKey())
                && Objects.equals(tagValue(), other.tagValue()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceScanResourcesRequest").add("ResourceScanId", resourceScanId())
                .add("ResourceIdentifier", resourceIdentifier()).add("ResourceTypePrefix", resourceTypePrefix())
                .add("TagKey", tagKey()).add("TagValue", tagValue()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceScanId":
            return Optional.ofNullable(clazz.cast(resourceScanId()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceTypePrefix":
            return Optional.ofNullable(clazz.cast(resourceTypePrefix()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "TagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceTypePrefix", RESOURCE_TYPE_PREFIX_FIELD);
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScanResourcesRequest, T> g) {
        return obj -> g.apply((ListResourceScanResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceScanResourcesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource scan.
         * </p>
         * 
         * @param resourceScanId
         *        The Amazon Resource Name (ARN) of the resource scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceScanId(String resourceScanId);

        /**
         * <p>
         * If specified, the returned resources will have the specified resource identifier (or one of them in the case
         * where the resource has multiple identifiers).
         * </p>
         * 
         * @param resourceIdentifier
         *        If specified, the returned resources will have the specified resource identifier (or one of them in
         *        the case where the resource has multiple identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * If specified, the returned resources will be of any of the resource types with the specified prefix.
         * </p>
         * 
         * @param resourceTypePrefix
         *        If specified, the returned resources will be of any of the resource types with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypePrefix(String resourceTypePrefix);

        /**
         * <p>
         * If specified, the returned resources will have a matching tag key.
         * </p>
         * 
         * @param tagKey
         *        If specified, the returned resources will have a matching tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * If specified, the returned resources will have a matching tag value.
         * </p>
         * 
         * @param tagValue
         *        If specified, the returned resources will have a matching tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value
         * that you can use for the <code>NextToken</code> parameter to get the next set of results. By default the
         * <code>ListResourceScanResources</code> API action will return at most 100 results in each response. The
         * maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        If the number of available results exceeds this maximum, the response includes a
         *        <code>NextToken</code> value that you can use for the <code>NextToken</code> parameter to get the next
         *        set of results. By default the <code>ListResourceScanResources</code> API action will return at most
         *        100 results in each response. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String resourceScanId;

        private String resourceIdentifier;

        private String resourceTypePrefix;

        private String tagKey;

        private String tagValue;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScanResourcesRequest model) {
            super(model);
            resourceScanId(model.resourceScanId);
            resourceIdentifier(model.resourceIdentifier);
            resourceTypePrefix(model.resourceTypePrefix);
            tagKey(model.tagKey);
            tagValue(model.tagValue);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceScanId() {
            return resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceTypePrefix() {
            return resourceTypePrefix;
        }

        public final void setResourceTypePrefix(String resourceTypePrefix) {
            this.resourceTypePrefix = resourceTypePrefix;
        }

        @Override
        public final Builder resourceTypePrefix(String resourceTypePrefix) {
            this.resourceTypePrefix = resourceTypePrefix;
            return this;
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceScanResourcesRequest build() {
            return new ListResourceScanResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
