/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestTypeResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, TestTypeResponse> {
    private static final SdkField<String> TYPE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionArn").getter(TestTypeResponse.getter(TestTypeResponse::typeVersionArn)).setter(TestTypeResponse.setter(Builder::typeVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_VERSION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestTypeResponse.memberNameToFieldInitializer();
    private final String typeVersionArn;

    private TestTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeVersionArn = builder.typeVersionArn;
    }

    public final String typeVersionArn() {
        return this.typeVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTypeResponse)) {
            return false;
        }
        TestTypeResponse other = (TestTypeResponse)((Object)obj);
        return Objects.equals(this.typeVersionArn(), other.typeVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"TestTypeResponse").add("TypeVersionArn", (Object)this.typeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeVersionArn": {
                return Optional.ofNullable(clazz.cast(this.typeVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TypeVersionArn", TYPE_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestTypeResponse, T> g) {
        return obj -> g.apply((TestTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String typeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TestTypeResponse model) {
            super(model);
            this.typeVersionArn(model.typeVersionArn);
        }

        public final String getTypeVersionArn() {
            return this.typeVersionArn;
        }

        public final void setTypeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
        }

        @Override
        public final Builder typeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
            return this;
        }

        @Override
        public TestTypeResponse build() {
            return new TestTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestTypeResponse> {
        public Builder typeVersionArn(String var1);
    }
}

