/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.HookResultSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.HookResultSummary;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHookResultsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListHookResultsResponse> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(ListHookResultsResponse.getter(ListHookResultsResponse::targetTypeAsString)).setter(ListHookResultsResponse.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(ListHookResultsResponse.getter(ListHookResultsResponse::targetId)).setter(ListHookResultsResponse.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<List<HookResultSummary>> HOOK_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HookResults").getter(ListHookResultsResponse.getter(ListHookResultsResponse::hookResults)).setter(ListHookResultsResponse.setter(Builder::hookResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HookResultSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHookResultsResponse.getter(ListHookResultsResponse::nextToken)).setter(ListHookResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, TARGET_ID_FIELD, HOOK_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHookResultsResponse.memberNameToFieldInitializer();
    private final String targetType;
    private final String targetId;
    private final List<HookResultSummary> hookResults;
    private final String nextToken;

    private ListHookResultsResponse(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.hookResults = builder.hookResults;
        this.nextToken = builder.nextToken;
    }

    public final ListHookResultsTargetType targetType() {
        return ListHookResultsTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final boolean hasHookResults() {
        return this.hookResults != null && !(this.hookResults instanceof SdkAutoConstructList);
    }

    public final List<HookResultSummary> hookResults() {
        return this.hookResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHookResults() ? this.hookResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHookResultsResponse)) {
            return false;
        }
        ListHookResultsResponse other = (ListHookResultsResponse)((Object)obj);
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetId(), other.targetId()) && this.hasHookResults() == other.hasHookResults() && Objects.equals(this.hookResults(), other.hookResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHookResultsResponse").add("TargetType", (Object)this.targetTypeAsString()).add("TargetId", (Object)this.targetId()).add("HookResults", this.hasHookResults() ? this.hookResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "HookResults": {
                return Optional.ofNullable(clazz.cast(this.hookResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("HookResults", HOOK_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHookResultsResponse, T> g) {
        return obj -> g.apply((ListHookResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String targetType;
        private String targetId;
        private List<HookResultSummary> hookResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHookResultsResponse model) {
            super(model);
            this.targetType(model.targetType);
            this.targetId(model.targetId);
            this.hookResults(model.hookResults);
            this.nextToken(model.nextToken);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ListHookResultsTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final List<HookResultSummary.Builder> getHookResults() {
            List<HookResultSummary.Builder> result = HookResultSummariesCopier.copyToBuilder(this.hookResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHookResults(Collection<HookResultSummary.BuilderImpl> hookResults) {
            this.hookResults = HookResultSummariesCopier.copyFromBuilder(hookResults);
        }

        @Override
        public final Builder hookResults(Collection<HookResultSummary> hookResults) {
            this.hookResults = HookResultSummariesCopier.copy(hookResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hookResults(HookResultSummary ... hookResults) {
            this.hookResults(Arrays.asList(hookResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hookResults(Consumer<HookResultSummary.Builder> ... hookResults) {
            this.hookResults(Stream.of(hookResults).map(c -> (HookResultSummary)((HookResultSummary.Builder)HookResultSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHookResultsResponse build() {
            return new ListHookResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHookResultsResponse> {
        public Builder targetType(String var1);

        public Builder targetType(ListHookResultsTargetType var1);

        public Builder targetId(String var1);

        public Builder hookResults(Collection<HookResultSummary> var1);

        public Builder hookResults(HookResultSummary ... var1);

        public Builder hookResults(Consumer<HookResultSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

