/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationWaiter;
import software.amazon.awssdk.services.cloudformation.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudFormationWaiter
implements CloudFormationWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CloudFormationClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeStacksResponse> stackExistsWaiter;
    private final Waiter<DescribeStacksResponse> stackCreateCompleteWaiter;
    private final Waiter<DescribeStacksResponse> stackDeleteCompleteWaiter;
    private final Waiter<DescribeStacksResponse> stackUpdateCompleteWaiter;
    private final Waiter<DescribeStacksResponse> stackImportCompleteWaiter;
    private final Waiter<DescribeStacksResponse> stackRollbackCompleteWaiter;
    private final Waiter<DescribeChangeSetResponse> changeSetCreateCompleteWaiter;
    private final Waiter<DescribeStackRefactorResponse> stackRefactorCreateCompleteWaiter;
    private final Waiter<DescribeStackRefactorResponse> stackRefactorExecuteCompleteWaiter;
    private final Waiter<DescribeTypeRegistrationResponse> typeRegistrationCompleteWaiter;

    private DefaultCloudFormationWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudFormationClient)CloudFormationClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.stackExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.stackCreateCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackCreateCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackDeleteCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackDeleteCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackDeleteCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackUpdateCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackUpdateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackUpdateCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackImportCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackImportCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackImportCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackRollbackCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationWaiter.stackRollbackCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackRollbackCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.changeSetCreateCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeChangeSetResponse.class).acceptors(DefaultCloudFormationWaiter.changeSetCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.changeSetCreateCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackRefactorCreateCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStackRefactorResponse.class).acceptors(DefaultCloudFormationWaiter.stackRefactorCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackRefactorCreateCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.stackRefactorExecuteCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStackRefactorResponse.class).acceptors(DefaultCloudFormationWaiter.stackRefactorExecuteCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.stackRefactorExecuteCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.typeRegistrationCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTypeRegistrationResponse.class).acceptors(DefaultCloudFormationWaiter.typeRegistrationCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationWaiter.typeRegistrationCompleteWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(DescribeChangeSetRequest describeChangeSetRequest) {
        return this.changeSetCreateCompleteWaiter.run(() -> this.client.describeChangeSet(this.applyWaitersUserAgent(describeChangeSetRequest)));
    }

    @Override
    public WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(DescribeChangeSetRequest describeChangeSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.changeSetCreateCompleteWaiter.run(() -> this.client.describeChangeSet(this.applyWaitersUserAgent(describeChangeSetRequest)), DefaultCloudFormationWaiter.changeSetCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackCreateCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackCreateCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackDeleteCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackDeleteCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackDeleteCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackExists(DescribeStacksRequest describeStacksRequest) {
        return this.stackExistsWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackExists(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackExistsWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackImportCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackImportCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackImportCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStackRefactorResponse> waitUntilStackRefactorCreateComplete(DescribeStackRefactorRequest describeStackRefactorRequest) {
        return this.stackRefactorCreateCompleteWaiter.run(() -> this.client.describeStackRefactor(this.applyWaitersUserAgent(describeStackRefactorRequest)));
    }

    @Override
    public WaiterResponse<DescribeStackRefactorResponse> waitUntilStackRefactorCreateComplete(DescribeStackRefactorRequest describeStackRefactorRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackRefactorCreateCompleteWaiter.run(() -> this.client.describeStackRefactor(this.applyWaitersUserAgent(describeStackRefactorRequest)), DefaultCloudFormationWaiter.stackRefactorCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStackRefactorResponse> waitUntilStackRefactorExecuteComplete(DescribeStackRefactorRequest describeStackRefactorRequest) {
        return this.stackRefactorExecuteCompleteWaiter.run(() -> this.client.describeStackRefactor(this.applyWaitersUserAgent(describeStackRefactorRequest)));
    }

    @Override
    public WaiterResponse<DescribeStackRefactorResponse> waitUntilStackRefactorExecuteComplete(DescribeStackRefactorRequest describeStackRefactorRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackRefactorExecuteCompleteWaiter.run(() -> this.client.describeStackRefactor(this.applyWaitersUserAgent(describeStackRefactorRequest)), DefaultCloudFormationWaiter.stackRefactorExecuteCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackRollbackCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackRollbackCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackRollbackCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackUpdateCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackUpdateCompleteWaiter.run(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationWaiter.stackUpdateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        return this.typeRegistrationCompleteWaiter.run(() -> this.client.describeTypeRegistration(this.applyWaitersUserAgent(describeTypeRegistrationRequest)));
    }

    @Override
    public WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest describeTypeRegistrationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.typeRegistrationCompleteWaiter.run(() -> this.client.describeTypeRegistration(this.applyWaitersUserAgent(describeTypeRegistrationRequest)), DefaultCloudFormationWaiter.typeRegistrationCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "CREATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "CREATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackDeleteCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "DELETE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "CREATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_IN_PROGRESS"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_IN_PROGRESS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_COMPLETE) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackUpdateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackImportCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "IMPORT_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_IN_PROGRESS"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_IN_PROGRESS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackRollbackCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChangeSetResponse>> changeSetCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChangeSetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChangeSetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStackRefactorResponse>> stackRefactorCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStackRefactorResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStackRefactorResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStackRefactorResponse>> stackRefactorExecuteCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStackRefactorResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStackRefactorResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExecutionStatus").value(), "EXECUTE_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExecutionStatus").value(), "EXECUTE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExecutionStatus=EXECUTE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExecutionStatus").value(), "ROLLBACK_COMPLETE");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExecutionStatus=ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTypeRegistrationResponse>> typeRegistrationCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTypeRegistrationResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTypeRegistrationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressStatus").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ProgressStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration stackExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackDeleteCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackUpdateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackImportCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackRollbackCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration changeSetCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackRefactorCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackRefactorExecuteCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration typeRegistrationCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudFormationWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudFormationRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFormationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudFormationWaiter.Builder {
        private CloudFormationClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CloudFormationWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudFormationWaiter.Builder client(CloudFormationClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudFormationWaiter build() {
            return new DefaultCloudFormationWaiter(this);
        }
    }
}

