/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackRefactorRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CreateStackRefactorRequest.Builder, CreateStackRefactorRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateStackRefactorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> ENABLE_STACK_CREATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableStackCreation").getter(getter(CreateStackRefactorRequest::enableStackCreation))
            .setter(setter(Builder::enableStackCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStackCreation").build())
            .build();

    private static final SdkField<List<ResourceMapping>> RESOURCE_MAPPINGS_FIELD = SdkField
            .<List<ResourceMapping>> builder(MarshallingType.LIST)
            .memberName("ResourceMappings")
            .getter(getter(CreateStackRefactorRequest::resourceMappings))
            .setter(setter(Builder::resourceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StackDefinition>> STACK_DEFINITIONS_FIELD = SdkField
            .<List<StackDefinition>> builder(MarshallingType.LIST)
            .memberName("StackDefinitions")
            .getter(getter(CreateStackRefactorRequest::stackDefinitions))
            .setter(setter(Builder::stackDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ENABLE_STACK_CREATION_FIELD, RESOURCE_MAPPINGS_FIELD, STACK_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final Boolean enableStackCreation;

    private final List<ResourceMapping> resourceMappings;

    private final List<StackDefinition> stackDefinitions;

    private CreateStackRefactorRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.enableStackCreation = builder.enableStackCreation;
        this.resourceMappings = builder.resourceMappings;
        this.stackDefinitions = builder.stackDefinitions;
    }

    /**
     * <p>
     * A description to help you identify the stack refactor.
     * </p>
     * 
     * @return A description to help you identify the stack refactor.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Determines if a new stack is created with the refactor.
     * </p>
     * 
     * @return Determines if a new stack is created with the refactor.
     */
    public final Boolean enableStackCreation() {
        return enableStackCreation;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceMappings() {
        return resourceMappings != null && !(resourceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceMappings} method.
     * </p>
     * 
     * @return The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
     */
    public final List<ResourceMapping> resourceMappings() {
        return resourceMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackDefinitions() {
        return stackDefinitions != null && !(stackDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stacks being refactored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackDefinitions} method.
     * </p>
     * 
     * @return The stacks being refactored.
     */
    public final List<StackDefinition> stackDefinitions() {
        return stackDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enableStackCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceMappings() ? resourceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStackDefinitions() ? stackDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRefactorRequest)) {
            return false;
        }
        CreateStackRefactorRequest other = (CreateStackRefactorRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(enableStackCreation(), other.enableStackCreation())
                && hasResourceMappings() == other.hasResourceMappings()
                && Objects.equals(resourceMappings(), other.resourceMappings())
                && hasStackDefinitions() == other.hasStackDefinitions()
                && Objects.equals(stackDefinitions(), other.stackDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStackRefactorRequest").add("Description", description())
                .add("EnableStackCreation", enableStackCreation())
                .add("ResourceMappings", hasResourceMappings() ? resourceMappings() : null)
                .add("StackDefinitions", hasStackDefinitions() ? stackDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnableStackCreation":
            return Optional.ofNullable(clazz.cast(enableStackCreation()));
        case "ResourceMappings":
            return Optional.ofNullable(clazz.cast(resourceMappings()));
        case "StackDefinitions":
            return Optional.ofNullable(clazz.cast(stackDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EnableStackCreation", ENABLE_STACK_CREATION_FIELD);
        map.put("ResourceMappings", RESOURCE_MAPPINGS_FIELD);
        map.put("StackDefinitions", STACK_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRefactorRequest, T> g) {
        return obj -> g.apply((CreateStackRefactorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackRefactorRequest> {
        /**
         * <p>
         * A description to help you identify the stack refactor.
         * </p>
         * 
         * @param description
         *        A description to help you identify the stack refactor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Determines if a new stack is created with the refactor.
         * </p>
         * 
         * @param enableStackCreation
         *        Determines if a new stack is created with the refactor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableStackCreation(Boolean enableStackCreation);

        /**
         * <p>
         * The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
         * </p>
         * 
         * @param resourceMappings
         *        The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMappings(Collection<ResourceMapping> resourceMappings);

        /**
         * <p>
         * The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
         * </p>
         * 
         * @param resourceMappings
         *        The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMappings(ResourceMapping... resourceMappings);

        /**
         * <p>
         * The mappings for the stack resource <code>Source</code> and stack resource <code>Destination</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceMappings(List<ResourceMapping>)}.
         * 
         * @param resourceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ResourceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceMappings(java.util.Collection<ResourceMapping>)
         */
        Builder resourceMappings(Consumer<ResourceMapping.Builder>... resourceMappings);

        /**
         * <p>
         * The stacks being refactored.
         * </p>
         * 
         * @param stackDefinitions
         *        The stacks being refactored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackDefinitions(Collection<StackDefinition> stackDefinitions);

        /**
         * <p>
         * The stacks being refactored.
         * </p>
         * 
         * @param stackDefinitions
         *        The stacks being refactored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackDefinitions(StackDefinition... stackDefinitions);

        /**
         * <p>
         * The stacks being refactored.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.StackDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.StackDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.StackDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #stackDefinitions(List<StackDefinition>)}.
         * 
         * @param stackDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.StackDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackDefinitions(java.util.Collection<StackDefinition>)
         */
        Builder stackDefinitions(Consumer<StackDefinition.Builder>... stackDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String description;

        private Boolean enableStackCreation;

        private List<ResourceMapping> resourceMappings = DefaultSdkAutoConstructList.getInstance();

        private List<StackDefinition> stackDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRefactorRequest model) {
            super(model);
            description(model.description);
            enableStackCreation(model.enableStackCreation);
            resourceMappings(model.resourceMappings);
            stackDefinitions(model.stackDefinitions);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnableStackCreation() {
            return enableStackCreation;
        }

        public final void setEnableStackCreation(Boolean enableStackCreation) {
            this.enableStackCreation = enableStackCreation;
        }

        @Override
        public final Builder enableStackCreation(Boolean enableStackCreation) {
            this.enableStackCreation = enableStackCreation;
            return this;
        }

        public final List<ResourceMapping.Builder> getResourceMappings() {
            List<ResourceMapping.Builder> result = ResourceMappingsCopier.copyToBuilder(this.resourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceMappings(Collection<ResourceMapping.BuilderImpl> resourceMappings) {
            this.resourceMappings = ResourceMappingsCopier.copyFromBuilder(resourceMappings);
        }

        @Override
        public final Builder resourceMappings(Collection<ResourceMapping> resourceMappings) {
            this.resourceMappings = ResourceMappingsCopier.copy(resourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(ResourceMapping... resourceMappings) {
            resourceMappings(Arrays.asList(resourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(Consumer<ResourceMapping.Builder>... resourceMappings) {
            resourceMappings(Stream.of(resourceMappings).map(c -> ResourceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StackDefinition.Builder> getStackDefinitions() {
            List<StackDefinition.Builder> result = StackDefinitionsCopier.copyToBuilder(this.stackDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackDefinitions(Collection<StackDefinition.BuilderImpl> stackDefinitions) {
            this.stackDefinitions = StackDefinitionsCopier.copyFromBuilder(stackDefinitions);
        }

        @Override
        public final Builder stackDefinitions(Collection<StackDefinition> stackDefinitions) {
            this.stackDefinitions = StackDefinitionsCopier.copy(stackDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackDefinitions(StackDefinition... stackDefinitions) {
            stackDefinitions(Arrays.asList(stackDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackDefinitions(Consumer<StackDefinition.Builder>... stackDefinitions) {
            stackDefinitions(Stream.of(stackDefinitions).map(c -> StackDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRefactorRequest build() {
            return new CreateStackRefactorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
