/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorAction;

public class ListStackRefactorActionsIterable
implements SdkIterable<ListStackRefactorActionsResponse> {
    private final CloudFormationClient client;
    private final ListStackRefactorActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackRefactorActionsIterable(CloudFormationClient client, ListStackRefactorActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStackRefactorActionsResponseFetcher();
    }

    public Iterator<ListStackRefactorActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackRefactorAction> stackRefactorActions() {
        Function<ListStackRefactorActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackRefactorActions() != null) {
                return response.stackRefactorActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackRefactorActionsResponseFetcher
    implements SyncPageFetcher<ListStackRefactorActionsResponse> {
        private ListStackRefactorActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackRefactorActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackRefactorActionsResponse nextPage(ListStackRefactorActionsResponse previousPage) {
            if (previousPage == null) {
                return ListStackRefactorActionsIterable.this.client.listStackRefactorActions(ListStackRefactorActionsIterable.this.firstRequest);
            }
            return ListStackRefactorActionsIterable.this.client.listStackRefactorActions((ListStackRefactorActionsRequest)((Object)ListStackRefactorActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

