/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceScanStatus {
    IN_PROGRESS("IN_PROGRESS"),
    FAILED("FAILED"),
    COMPLETE("COMPLETE"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceScanStatus> VALUE_MAP;
    private final String value;

    private ResourceScanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceScanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceScanStatus> knownValues() {
        EnumSet<ResourceScanStatus> knownValues = EnumSet.allOf(ResourceScanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceScanStatus.class, ResourceScanStatus::toString);
    }
}

