/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateDeletionPolicy;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateUpdateReplacePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateConfiguration> {
    private static final SdkField<String> DELETION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionPolicy").getter(TemplateConfiguration.getter(TemplateConfiguration::deletionPolicyAsString)).setter(TemplateConfiguration.setter(Builder::deletionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionPolicy").build()}).build();
    private static final SdkField<String> UPDATE_REPLACE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateReplacePolicy").getter(TemplateConfiguration.getter(TemplateConfiguration::updateReplacePolicyAsString)).setter(TemplateConfiguration.setter(Builder::updateReplacePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateReplacePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_POLICY_FIELD, UPDATE_REPLACE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deletionPolicy;
    private final String updateReplacePolicy;

    private TemplateConfiguration(BuilderImpl builder) {
        this.deletionPolicy = builder.deletionPolicy;
        this.updateReplacePolicy = builder.updateReplacePolicy;
    }

    public final GeneratedTemplateDeletionPolicy deletionPolicy() {
        return GeneratedTemplateDeletionPolicy.fromValue(this.deletionPolicy);
    }

    public final String deletionPolicyAsString() {
        return this.deletionPolicy;
    }

    public final GeneratedTemplateUpdateReplacePolicy updateReplacePolicy() {
        return GeneratedTemplateUpdateReplacePolicy.fromValue(this.updateReplacePolicy);
    }

    public final String updateReplacePolicyAsString() {
        return this.updateReplacePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReplacePolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration)obj;
        return Objects.equals(this.deletionPolicyAsString(), other.deletionPolicyAsString()) && Objects.equals(this.updateReplacePolicyAsString(), other.updateReplacePolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateConfiguration").add("DeletionPolicy", (Object)this.deletionPolicyAsString()).add("UpdateReplacePolicy", (Object)this.updateReplacePolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletionPolicy": {
                return Optional.ofNullable(clazz.cast(this.deletionPolicyAsString()));
            }
            case "UpdateReplacePolicy": {
                return Optional.ofNullable(clazz.cast(this.updateReplacePolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DeletionPolicy", DELETION_POLICY_FIELD);
        map.put("UpdateReplacePolicy", UPDATE_REPLACE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateConfiguration, T> g) {
        return obj -> g.apply((TemplateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deletionPolicy;
        private String updateReplacePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateConfiguration model) {
            this.deletionPolicy(model.deletionPolicy);
            this.updateReplacePolicy(model.updateReplacePolicy);
        }

        public final String getDeletionPolicy() {
            return this.deletionPolicy;
        }

        public final void setDeletionPolicy(String deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
        }

        @Override
        public final Builder deletionPolicy(String deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            return this;
        }

        @Override
        public final Builder deletionPolicy(GeneratedTemplateDeletionPolicy deletionPolicy) {
            this.deletionPolicy(deletionPolicy == null ? null : deletionPolicy.toString());
            return this;
        }

        public final String getUpdateReplacePolicy() {
            return this.updateReplacePolicy;
        }

        public final void setUpdateReplacePolicy(String updateReplacePolicy) {
            this.updateReplacePolicy = updateReplacePolicy;
        }

        @Override
        public final Builder updateReplacePolicy(String updateReplacePolicy) {
            this.updateReplacePolicy = updateReplacePolicy;
            return this;
        }

        @Override
        public final Builder updateReplacePolicy(GeneratedTemplateUpdateReplacePolicy updateReplacePolicy) {
            this.updateReplacePolicy(updateReplacePolicy == null ? null : updateReplacePolicy.toString());
            return this;
        }

        public TemplateConfiguration build() {
            return new TemplateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateConfiguration> {
        public Builder deletionPolicy(String var1);

        public Builder deletionPolicy(GeneratedTemplateDeletionPolicy var1);

        public Builder updateReplacePolicy(String var1);

        public Builder updateReplacePolicy(GeneratedTemplateUpdateReplacePolicy var1);
    }
}

