/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.StackDriftStatus;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackInstance> {
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetId").getter(StackInstance.getter(StackInstance::stackSetId)).setter(StackInstance.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(StackInstance.getter(StackInstance::region)).setter(StackInstance.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(StackInstance.getter(StackInstance::account)).setter(StackInstance.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(StackInstance.getter(StackInstance::stackId)).setter(StackInstance.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterOverrides").getter(StackInstance.getter(StackInstance::parameterOverrides)).setter(StackInstance.setter(Builder::parameterOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StackInstance.getter(StackInstance::statusAsString)).setter(StackInstance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<StackInstanceComprehensiveStatus> STACK_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackInstanceStatus").getter(StackInstance.getter(StackInstance::stackInstanceStatus)).setter(StackInstance.setter(Builder::stackInstanceStatus)).constructor(StackInstanceComprehensiveStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceStatus").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(StackInstance.getter(StackInstance::statusReason)).setter(StackInstance.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitId").getter(StackInstance.getter(StackInstance::organizationalUnitId)).setter(StackInstance.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build()}).build();
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DriftStatus").getter(StackInstance.getter(StackInstance::driftStatusAsString)).setter(StackInstance.setter(Builder::driftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftStatus").build()}).build();
    private static final SdkField<Instant> LAST_DRIFT_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastDriftCheckTimestamp").getter(StackInstance.getter(StackInstance::lastDriftCheckTimestamp)).setter(StackInstance.setter(Builder::lastDriftCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDriftCheckTimestamp").build()}).build();
    private static final SdkField<String> LAST_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastOperationId").getter(StackInstance.getter(StackInstance::lastOperationId)).setter(StackInstance.setter(Builder::lastOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastOperationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ID_FIELD, REGION_FIELD, ACCOUNT_FIELD, STACK_ID_FIELD, PARAMETER_OVERRIDES_FIELD, STATUS_FIELD, STACK_INSTANCE_STATUS_FIELD, STATUS_REASON_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, DRIFT_STATUS_FIELD, LAST_DRIFT_CHECK_TIMESTAMP_FIELD, LAST_OPERATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StackInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stackSetId;
    private final String region;
    private final String account;
    private final String stackId;
    private final List<Parameter> parameterOverrides;
    private final String status;
    private final StackInstanceComprehensiveStatus stackInstanceStatus;
    private final String statusReason;
    private final String organizationalUnitId;
    private final String driftStatus;
    private final Instant lastDriftCheckTimestamp;
    private final String lastOperationId;

    private StackInstance(BuilderImpl builder) {
        this.stackSetId = builder.stackSetId;
        this.region = builder.region;
        this.account = builder.account;
        this.stackId = builder.stackId;
        this.parameterOverrides = builder.parameterOverrides;
        this.status = builder.status;
        this.stackInstanceStatus = builder.stackInstanceStatus;
        this.statusReason = builder.statusReason;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.driftStatus = builder.driftStatus;
        this.lastDriftCheckTimestamp = builder.lastDriftCheckTimestamp;
        this.lastOperationId = builder.lastOperationId;
    }

    public final String stackSetId() {
        return this.stackSetId;
    }

    public final String region() {
        return this.region;
    }

    public final String account() {
        return this.account;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final boolean hasParameterOverrides() {
        return this.parameterOverrides != null && !(this.parameterOverrides instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameterOverrides() {
        return this.parameterOverrides;
    }

    public final StackInstanceStatus status() {
        return StackInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StackInstanceComprehensiveStatus stackInstanceStatus() {
        return this.stackInstanceStatus;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public final StackDriftStatus driftStatus() {
        return StackDriftStatus.fromValue(this.driftStatus);
    }

    public final String driftStatusAsString() {
        return this.driftStatus;
    }

    public final Instant lastDriftCheckTimestamp() {
        return this.lastDriftCheckTimestamp;
    }

    public final String lastOperationId() {
        return this.lastOperationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterOverrides() ? this.parameterOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDriftCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastOperationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstance)) {
            return false;
        }
        StackInstance other = (StackInstance)obj;
        return Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.account(), other.account()) && Objects.equals(this.stackId(), other.stackId()) && this.hasParameterOverrides() == other.hasParameterOverrides() && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.stackInstanceStatus(), other.stackInstanceStatus()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(this.driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(this.lastDriftCheckTimestamp(), other.lastDriftCheckTimestamp()) && Objects.equals(this.lastOperationId(), other.lastOperationId());
    }

    public final String toString() {
        return ToString.builder((String)"StackInstance").add("StackSetId", (Object)this.stackSetId()).add("Region", (Object)this.region()).add("Account", (Object)this.account()).add("StackId", (Object)this.stackId()).add("ParameterOverrides", this.hasParameterOverrides() ? this.parameterOverrides() : null).add("Status", (Object)this.statusAsString()).add("StackInstanceStatus", (Object)this.stackInstanceStatus()).add("StatusReason", (Object)this.statusReason()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).add("DriftStatus", (Object)this.driftStatusAsString()).add("LastDriftCheckTimestamp", (Object)this.lastDriftCheckTimestamp()).add("LastOperationId", (Object)this.lastOperationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "ParameterOverrides": {
                return Optional.ofNullable(clazz.cast(this.parameterOverrides()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StackInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.stackInstanceStatus()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "OrganizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
            case "DriftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatusAsString()));
            }
            case "LastDriftCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastDriftCheckTimestamp()));
            }
            case "LastOperationId": {
                return Optional.ofNullable(clazz.cast(this.lastOperationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackSetId", STACK_SET_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("ParameterOverrides", PARAMETER_OVERRIDES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StackInstanceStatus", STACK_INSTANCE_STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("DriftStatus", DRIFT_STATUS_FIELD);
        map.put("LastDriftCheckTimestamp", LAST_DRIFT_CHECK_TIMESTAMP_FIELD);
        map.put("LastOperationId", LAST_OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackInstance, T> g) {
        return obj -> g.apply((StackInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetId;
        private String region;
        private String account;
        private String stackId;
        private List<Parameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private StackInstanceComprehensiveStatus stackInstanceStatus;
        private String statusReason;
        private String organizationalUnitId;
        private String driftStatus;
        private Instant lastDriftCheckTimestamp;
        private String lastOperationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstance model) {
            this.stackSetId(model.stackSetId);
            this.region(model.region);
            this.account(model.account);
            this.stackId(model.stackId);
            this.parameterOverrides(model.parameterOverrides);
            this.status(model.status);
            this.stackInstanceStatus(model.stackInstanceStatus);
            this.statusReason(model.statusReason);
            this.organizationalUnitId(model.organizationalUnitId);
            this.driftStatus(model.driftStatus);
            this.lastDriftCheckTimestamp(model.lastDriftCheckTimestamp);
            this.lastOperationId(model.lastOperationId);
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final List<Parameter.Builder> getParameterOverrides() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameterOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterOverrides(Collection<Parameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copyFromBuilder(parameterOverrides);
        }

        @Override
        public final Builder parameterOverrides(Collection<Parameter> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Parameter ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<Parameter.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StackInstanceComprehensiveStatus.Builder getStackInstanceStatus() {
            return this.stackInstanceStatus != null ? this.stackInstanceStatus.toBuilder() : null;
        }

        public final void setStackInstanceStatus(StackInstanceComprehensiveStatus.BuilderImpl stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus != null ? stackInstanceStatus.build() : null;
        }

        @Override
        public final Builder stackInstanceStatus(StackInstanceComprehensiveStatus stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getDriftStatus() {
            return this.driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(StackDriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getLastDriftCheckTimestamp() {
            return this.lastDriftCheckTimestamp;
        }

        public final void setLastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
        }

        @Override
        public final Builder lastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
            return this;
        }

        public final String getLastOperationId() {
            return this.lastOperationId;
        }

        public final void setLastOperationId(String lastOperationId) {
            this.lastOperationId = lastOperationId;
        }

        @Override
        public final Builder lastOperationId(String lastOperationId) {
            this.lastOperationId = lastOperationId;
            return this;
        }

        public StackInstance build() {
            return new StackInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackInstance> {
        public Builder stackSetId(String var1);

        public Builder region(String var1);

        public Builder account(String var1);

        public Builder stackId(String var1);

        public Builder parameterOverrides(Collection<Parameter> var1);

        public Builder parameterOverrides(Parameter ... var1);

        public Builder parameterOverrides(Consumer<Parameter.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(StackInstanceStatus var1);

        public Builder stackInstanceStatus(StackInstanceComprehensiveStatus var1);

        default public Builder stackInstanceStatus(Consumer<StackInstanceComprehensiveStatus.Builder> stackInstanceStatus) {
            return this.stackInstanceStatus((StackInstanceComprehensiveStatus)((StackInstanceComprehensiveStatus.Builder)StackInstanceComprehensiveStatus.builder().applyMutation(stackInstanceStatus)).build());
        }

        public Builder statusReason(String var1);

        public Builder organizationalUnitId(String var1);

        public Builder driftStatus(String var1);

        public Builder driftStatus(StackDriftStatus var1);

        public Builder lastDriftCheckTimestamp(Instant var1);

        public Builder lastOperationId(String var1);
    }
}

