/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifier;
import software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceScanRelatedResourcesRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListResourceScanRelatedResourcesRequest> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceScanId").getter(ListResourceScanRelatedResourcesRequest.getter(ListResourceScanRelatedResourcesRequest::resourceScanId)).setter(ListResourceScanRelatedResourcesRequest.setter(Builder::resourceScanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()}).build();
    private static final SdkField<List<ScannedResourceIdentifier>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(ListResourceScanRelatedResourcesRequest.getter(ListResourceScanRelatedResourcesRequest::resources)).setter(ListResourceScanRelatedResourcesRequest.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScannedResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceScanRelatedResourcesRequest.getter(ListResourceScanRelatedResourcesRequest::nextToken)).setter(ListResourceScanRelatedResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourceScanRelatedResourcesRequest.getter(ListResourceScanRelatedResourcesRequest::maxResults)).setter(ListResourceScanRelatedResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD, RESOURCES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceScanRelatedResourcesRequest.memberNameToFieldInitializer();
    private final String resourceScanId;
    private final List<ScannedResourceIdentifier> resources;
    private final String nextToken;
    private final Integer maxResults;

    private ListResourceScanRelatedResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String resourceScanId() {
        return this.resourceScanId;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ScannedResourceIdentifier> resources() {
        return this.resources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanRelatedResourcesRequest)) {
            return false;
        }
        ListResourceScanRelatedResourcesRequest other = (ListResourceScanRelatedResourcesRequest)((Object)obj);
        return Objects.equals(this.resourceScanId(), other.resourceScanId()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceScanRelatedResourcesRequest").add("ResourceScanId", (Object)this.resourceScanId()).add("Resources", this.hasResources() ? this.resources() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanId": {
                return Optional.ofNullable(clazz.cast(this.resourceScanId()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScanRelatedResourcesRequest, T> g) {
        return obj -> g.apply((ListResourceScanRelatedResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String resourceScanId;
        private List<ScannedResourceIdentifier> resources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScanRelatedResourcesRequest model) {
            super(model);
            this.resourceScanId(model.resourceScanId);
            this.resources(model.resources);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getResourceScanId() {
            return this.resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final List<ScannedResourceIdentifier.Builder> getResources() {
            List<ScannedResourceIdentifier.Builder> result = ScannedResourceIdentifiersCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ScannedResourceIdentifier.BuilderImpl> resources) {
            this.resources = ScannedResourceIdentifiersCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ScannedResourceIdentifier> resources) {
            this.resources = ScannedResourceIdentifiersCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ScannedResourceIdentifier ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ScannedResourceIdentifier.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ScannedResourceIdentifier)((ScannedResourceIdentifier.Builder)ScannedResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceScanRelatedResourcesRequest build() {
            return new ListResourceScanRelatedResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceScanRelatedResourcesRequest> {
        public Builder resourceScanId(String var1);

        public Builder resources(Collection<ScannedResourceIdentifier> var1);

        public Builder resources(ScannedResourceIdentifier ... var1);

        public Builder resources(Consumer<ScannedResourceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

