/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclarationsCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.services.cloudformation.model.Warnings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateSummaryResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetTemplateSummaryResponse> {
    private static final SdkField<List<ParameterDeclaration>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::parameters)).setter(GetTemplateSummaryResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::description)).setter(GetTemplateSummaryResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::capabilitiesAsStrings)).setter(GetTemplateSummaryResponse.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CAPABILITIES_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapabilitiesReason").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::capabilitiesReason)).setter(GetTemplateSummaryResponse.setter(Builder::capabilitiesReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitiesReason").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::resourceTypes)).setter(GetTemplateSummaryResponse.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::version)).setter(GetTemplateSummaryResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::metadata)).setter(GetTemplateSummaryResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<List<String>> DECLARED_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeclaredTransforms").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::declaredTransforms)).setter(GetTemplateSummaryResponse.setter(Builder::declaredTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeclaredTransforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceIdentifierSummary>> RESOURCE_IDENTIFIER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifierSummaries").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::resourceIdentifierSummaries)).setter(GetTemplateSummaryResponse.setter(Builder::resourceIdentifierSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifierSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceIdentifierSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Warnings> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Warnings").getter(GetTemplateSummaryResponse.getter(GetTemplateSummaryResponse::warnings)).setter(GetTemplateSummaryResponse.setter(Builder::warnings)).constructor(Warnings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, CAPABILITIES_REASON_FIELD, RESOURCE_TYPES_FIELD, VERSION_FIELD, METADATA_FIELD, DECLARED_TRANSFORMS_FIELD, RESOURCE_IDENTIFIER_SUMMARIES_FIELD, WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemplateSummaryResponse.memberNameToFieldInitializer();
    private final List<ParameterDeclaration> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> resourceTypes;
    private final String version;
    private final String metadata;
    private final List<String> declaredTransforms;
    private final List<ResourceIdentifierSummary> resourceIdentifierSummaries;
    private final Warnings warnings;

    private GetTemplateSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.resourceTypes = builder.resourceTypes;
        this.version = builder.version;
        this.metadata = builder.metadata;
        this.declaredTransforms = builder.declaredTransforms;
        this.resourceIdentifierSummaries = builder.resourceIdentifierSummaries;
        this.warnings = builder.warnings;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ParameterDeclaration> parameters() {
        return this.parameters;
    }

    public final String description() {
        return this.description;
    }

    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final String version() {
        return this.version;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final boolean hasDeclaredTransforms() {
        return this.declaredTransforms != null && !(this.declaredTransforms instanceof SdkAutoConstructList);
    }

    public final List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public final boolean hasResourceIdentifierSummaries() {
        return this.resourceIdentifierSummaries != null && !(this.resourceIdentifierSummaries instanceof SdkAutoConstructList);
    }

    public final List<ResourceIdentifierSummary> resourceIdentifierSummaries() {
        return this.resourceIdentifierSummaries;
    }

    public final Warnings warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeclaredTransforms() ? this.declaredTransforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifierSummaries() ? this.resourceIdentifierSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResponse)) {
            return false;
        }
        GetTemplateSummaryResponse other = (GetTemplateSummaryResponse)((Object)obj);
        return this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.description(), other.description()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.capabilitiesReason(), other.capabilitiesReason()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.metadata(), other.metadata()) && this.hasDeclaredTransforms() == other.hasDeclaredTransforms() && Objects.equals(this.declaredTransforms(), other.declaredTransforms()) && this.hasResourceIdentifierSummaries() == other.hasResourceIdentifierSummaries() && Objects.equals(this.resourceIdentifierSummaries(), other.resourceIdentifierSummaries()) && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateSummaryResponse").add("Parameters", this.hasParameters() ? this.parameters() : null).add("Description", (Object)this.description()).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("CapabilitiesReason", (Object)this.capabilitiesReason()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("Version", (Object)this.version()).add("Metadata", (Object)this.metadata()).add("DeclaredTransforms", this.hasDeclaredTransforms() ? this.declaredTransforms() : null).add("ResourceIdentifierSummaries", this.hasResourceIdentifierSummaries() ? this.resourceIdentifierSummaries() : null).add("Warnings", (Object)this.warnings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "CapabilitiesReason": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesReason()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "DeclaredTransforms": {
                return Optional.ofNullable(clazz.cast(this.declaredTransforms()));
            }
            case "ResourceIdentifierSummaries": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifierSummaries()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("CapabilitiesReason", CAPABILITIES_REASON_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("DeclaredTransforms", DECLARED_TRANSFORMS_FIELD);
        map.put("ResourceIdentifierSummaries", RESOURCE_IDENTIFIER_SUMMARIES_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryResponse, T> g) {
        return obj -> g.apply((GetTemplateSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<ParameterDeclaration> parameters = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String capabilitiesReason;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String version;
        private String metadata;
        private List<String> declaredTransforms = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceIdentifierSummary> resourceIdentifierSummaries = DefaultSdkAutoConstructList.getInstance();
        private Warnings warnings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryResponse model) {
            super(model);
            this.parameters(model.parameters);
            this.description(model.description);
            this.capabilitiesWithStrings(model.capabilities);
            this.capabilitiesReason(model.capabilitiesReason);
            this.resourceTypes(model.resourceTypes);
            this.version(model.version);
            this.metadata(model.metadata);
            this.declaredTransforms(model.declaredTransforms);
            this.resourceIdentifierSummaries(model.resourceIdentifierSummaries);
            this.warnings(model.warnings);
        }

        public final List<ParameterDeclaration.Builder> getParameters() {
            List<ParameterDeclaration.Builder> result = ParameterDeclarationsCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ParameterDeclaration.BuilderImpl> parameters) {
            this.parameters = ParameterDeclarationsCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterDeclaration ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ParameterDeclaration.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ParameterDeclaration)((ParameterDeclaration.Builder)ParameterDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Collection<String> getDeclaredTransforms() {
            if (this.declaredTransforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.declaredTransforms;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final List<ResourceIdentifierSummary.Builder> getResourceIdentifierSummaries() {
            List<ResourceIdentifierSummary.Builder> result = ResourceIdentifierSummariesCopier.copyToBuilder(this.resourceIdentifierSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifierSummaries(Collection<ResourceIdentifierSummary.BuilderImpl> resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries = ResourceIdentifierSummariesCopier.copyFromBuilder(resourceIdentifierSummaries);
        }

        @Override
        public final Builder resourceIdentifierSummaries(Collection<ResourceIdentifierSummary> resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries = ResourceIdentifierSummariesCopier.copy(resourceIdentifierSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifierSummaries(ResourceIdentifierSummary ... resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries(Arrays.asList(resourceIdentifierSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifierSummaries(Consumer<ResourceIdentifierSummary.Builder> ... resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries(Stream.of(resourceIdentifierSummaries).map(c -> (ResourceIdentifierSummary)((ResourceIdentifierSummary.Builder)ResourceIdentifierSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Warnings.Builder getWarnings() {
            return this.warnings != null ? this.warnings.toBuilder() : null;
        }

        public final void setWarnings(Warnings.BuilderImpl warnings) {
            this.warnings = warnings != null ? warnings.build() : null;
        }

        @Override
        public final Builder warnings(Warnings warnings) {
            this.warnings = warnings;
            return this;
        }

        @Override
        public GetTemplateSummaryResponse build() {
            return new GetTemplateSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateSummaryResponse> {
        public Builder parameters(Collection<ParameterDeclaration> var1);

        public Builder parameters(ParameterDeclaration ... var1);

        public Builder parameters(Consumer<ParameterDeclaration.Builder> ... var1);

        public Builder description(String var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder version(String var1);

        public Builder metadata(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);

        public Builder resourceIdentifierSummaries(Collection<ResourceIdentifierSummary> var1);

        public Builder resourceIdentifierSummaries(ResourceIdentifierSummary ... var1);

        public Builder resourceIdentifierSummaries(Consumer<ResourceIdentifierSummary.Builder> ... var1);

        public Builder warnings(Warnings var1);

        default public Builder warnings(Consumer<Warnings.Builder> warnings) {
            return this.warnings((Warnings)((Warnings.Builder)Warnings.builder().applyMutation(warnings)).build());
        }
    }
}

