/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackRefactorResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, CreateStackRefactorResponse> {
    private static final SdkField<String> STACK_REFACTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackRefactorId").getter(CreateStackRefactorResponse.getter(CreateStackRefactorResponse::stackRefactorId)).setter(CreateStackRefactorResponse.setter(Builder::stackRefactorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_REFACTOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStackRefactorResponse.memberNameToFieldInitializer();
    private final String stackRefactorId;

    private CreateStackRefactorResponse(BuilderImpl builder) {
        super(builder);
        this.stackRefactorId = builder.stackRefactorId;
    }

    public final String stackRefactorId() {
        return this.stackRefactorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackRefactorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRefactorResponse)) {
            return false;
        }
        CreateStackRefactorResponse other = (CreateStackRefactorResponse)((Object)obj);
        return Objects.equals(this.stackRefactorId(), other.stackRefactorId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStackRefactorResponse").add("StackRefactorId", (Object)this.stackRefactorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackRefactorId": {
                return Optional.ofNullable(clazz.cast(this.stackRefactorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StackRefactorId", STACK_REFACTOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRefactorResponse, T> g) {
        return obj -> g.apply((CreateStackRefactorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String stackRefactorId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRefactorResponse model) {
            super(model);
            this.stackRefactorId(model.stackRefactorId);
        }

        public final String getStackRefactorId() {
            return this.stackRefactorId;
        }

        public final void setStackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
        }

        @Override
        public final Builder stackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
            return this;
        }

        @Override
        public CreateStackRefactorResponse build() {
            return new CreateStackRefactorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStackRefactorResponse> {
        public Builder stackRefactorId(String var1);
    }
}

