/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateStatus;
import software.amazon.awssdk.services.cloudformation.model.ResourceDetail;
import software.amazon.awssdk.services.cloudformation.model.ResourceDetailsCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateConfiguration;
import software.amazon.awssdk.services.cloudformation.model.TemplateProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGeneratedTemplateResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeGeneratedTemplateResponse> {
    private static final SdkField<String> GENERATED_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateId").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::generatedTemplateId)).setter(DescribeGeneratedTemplateResponse.setter(Builder::generatedTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateId").build()}).build();
    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateName").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::generatedTemplateName)).setter(DescribeGeneratedTemplateResponse.setter(Builder::generatedTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build()}).build();
    private static final SdkField<List<ResourceDetail>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::resources)).setter(DescribeGeneratedTemplateResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::statusAsString)).setter(DescribeGeneratedTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::statusReason)).setter(DescribeGeneratedTemplateResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::creationTime)).setter(DescribeGeneratedTemplateResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::lastUpdatedTime)).setter(DescribeGeneratedTemplateResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<TemplateProgress> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Progress").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::progress)).setter(DescribeGeneratedTemplateResponse.setter(Builder::progress)).constructor(TemplateProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::stackId)).setter(DescribeGeneratedTemplateResponse.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::templateConfiguration)).setter(DescribeGeneratedTemplateResponse.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<Integer> TOTAL_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalWarnings").getter(DescribeGeneratedTemplateResponse.getter(DescribeGeneratedTemplateResponse::totalWarnings)).setter(DescribeGeneratedTemplateResponse.setter(Builder::totalWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalWarnings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_ID_FIELD, GENERATED_TEMPLATE_NAME_FIELD, RESOURCES_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, PROGRESS_FIELD, STACK_ID_FIELD, TEMPLATE_CONFIGURATION_FIELD, TOTAL_WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGeneratedTemplateResponse.memberNameToFieldInitializer();
    private final String generatedTemplateId;
    private final String generatedTemplateName;
    private final List<ResourceDetail> resources;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final TemplateProgress progress;
    private final String stackId;
    private final TemplateConfiguration templateConfiguration;
    private final Integer totalWarnings;

    private DescribeGeneratedTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.generatedTemplateId = builder.generatedTemplateId;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.resources = builder.resources;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.progress = builder.progress;
        this.stackId = builder.stackId;
        this.templateConfiguration = builder.templateConfiguration;
        this.totalWarnings = builder.totalWarnings;
    }

    public final String generatedTemplateId() {
        return this.generatedTemplateId;
    }

    public final String generatedTemplateName() {
        return this.generatedTemplateName;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourceDetail> resources() {
        return this.resources;
    }

    public final GeneratedTemplateStatus status() {
        return GeneratedTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final TemplateProgress progress() {
        return this.progress;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final Integer totalWarnings() {
        return this.totalWarnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalWarnings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGeneratedTemplateResponse)) {
            return false;
        }
        DescribeGeneratedTemplateResponse other = (DescribeGeneratedTemplateResponse)((Object)obj);
        return Objects.equals(this.generatedTemplateId(), other.generatedTemplateId()) && Objects.equals(this.generatedTemplateName(), other.generatedTemplateName()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.totalWarnings(), other.totalWarnings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGeneratedTemplateResponse").add("GeneratedTemplateId", (Object)this.generatedTemplateId()).add("GeneratedTemplateName", (Object)this.generatedTemplateName()).add("Resources", this.hasResources() ? this.resources() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Progress", (Object)this.progress()).add("StackId", (Object)this.stackId()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TotalWarnings", (Object)this.totalWarnings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeneratedTemplateId": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateId()));
            }
            case "GeneratedTemplateName": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateName()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TotalWarnings": {
                return Optional.ofNullable(clazz.cast(this.totalWarnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeneratedTemplateId", GENERATED_TEMPLATE_ID_FIELD);
        map.put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("TotalWarnings", TOTAL_WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGeneratedTemplateResponse, T> g) {
        return obj -> g.apply((DescribeGeneratedTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String generatedTemplateId;
        private String generatedTemplateName;
        private List<ResourceDetail> resources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private TemplateProgress progress;
        private String stackId;
        private TemplateConfiguration templateConfiguration;
        private Integer totalWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGeneratedTemplateResponse model) {
            super(model);
            this.generatedTemplateId(model.generatedTemplateId);
            this.generatedTemplateName(model.generatedTemplateName);
            this.resources(model.resources);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.progress(model.progress);
            this.stackId(model.stackId);
            this.templateConfiguration(model.templateConfiguration);
            this.totalWarnings(model.totalWarnings);
        }

        public final String getGeneratedTemplateId() {
            return this.generatedTemplateId;
        }

        public final void setGeneratedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
        }

        @Override
        public final Builder generatedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
            return this;
        }

        public final String getGeneratedTemplateName() {
            return this.generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final List<ResourceDetail.Builder> getResources() {
            List<ResourceDetail.Builder> result = ResourceDetailsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceDetail.BuilderImpl> resources) {
            this.resources = ResourceDetailsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceDetail> resources) {
            this.resources = ResourceDetailsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceDetail ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceDetail.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourceDetail)((ResourceDetail.Builder)ResourceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final TemplateProgress.Builder getProgress() {
            return this.progress != null ? this.progress.toBuilder() : null;
        }

        public final void setProgress(TemplateProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(TemplateProgress progress) {
            this.progress = progress;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final Integer getTotalWarnings() {
            return this.totalWarnings;
        }

        public final void setTotalWarnings(Integer totalWarnings) {
            this.totalWarnings = totalWarnings;
        }

        @Override
        public final Builder totalWarnings(Integer totalWarnings) {
            this.totalWarnings = totalWarnings;
            return this;
        }

        @Override
        public DescribeGeneratedTemplateResponse build() {
            return new DescribeGeneratedTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGeneratedTemplateResponse> {
        public Builder generatedTemplateId(String var1);

        public Builder generatedTemplateName(String var1);

        public Builder resources(Collection<ResourceDetail> var1);

        public Builder resources(ResourceDetail ... var1);

        public Builder resources(Consumer<ResourceDetail.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(GeneratedTemplateStatus var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder progress(TemplateProgress var1);

        default public Builder progress(Consumer<TemplateProgress.Builder> progress) {
            return this.progress((TemplateProgress)((TemplateProgress.Builder)TemplateProgress.builder().applyMutation(progress)).build());
        }

        public Builder stackId(String var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder totalWarnings(Integer var1);
    }
}

