/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateResourceStatus;
import software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierPropertiesCopier;
import software.amazon.awssdk.services.cloudformation.model.WarningDetail;
import software.amazon.awssdk.services.cloudformation.model.WarningDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetail> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceDetail.getter(ResourceDetail::resourceType)).setter(ResourceDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(ResourceDetail.getter(ResourceDetail::logicalResourceId)).setter(ResourceDetail.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResourceIdentifier").getter(ResourceDetail.getter(ResourceDetail::resourceIdentifier)).setter(ResourceDetail.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(ResourceDetail.getter(ResourceDetail::resourceStatusAsString)).setter(ResourceDetail.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatusReason").getter(ResourceDetail.getter(ResourceDetail::resourceStatusReason)).setter(ResourceDetail.setter(Builder::resourceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build()}).build();
    private static final SdkField<List<WarningDetail>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(ResourceDetail.getter(ResourceDetail::warnings)).setter(ResourceDetail.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WarningDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, LOGICAL_RESOURCE_ID_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
            this.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
            this.put("ResourceStatus", RESOURCE_STATUS_FIELD);
            this.put("ResourceStatusReason", RESOURCE_STATUS_REASON_FIELD);
            this.put("Warnings", WARNINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String logicalResourceId;
    private final Map<String, String> resourceIdentifier;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final List<WarningDetail> warnings;

    private ResourceDetail(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.warnings = builder.warnings;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final boolean hasResourceIdentifier() {
        return this.resourceIdentifier != null && !(this.resourceIdentifier instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final GeneratedTemplateResourceStatus resourceStatus() {
        return GeneratedTemplateResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<WarningDetail> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifier() ? this.resourceIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetail)) {
            return false;
        }
        ResourceDetail other = (ResourceDetail)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && this.hasResourceIdentifier() == other.hasResourceIdentifier() && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDetail").add("ResourceType", (Object)this.resourceType()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("ResourceIdentifier", this.hasResourceIdentifier() ? this.resourceIdentifier() : null).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusReason()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetail, T> g) {
        return obj -> g.apply((ResourceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String logicalResourceId;
        private Map<String, String> resourceIdentifier = DefaultSdkAutoConstructMap.getInstance();
        private String resourceStatus;
        private String resourceStatusReason;
        private List<WarningDetail> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetail model) {
            this.resourceType(model.resourceType);
            this.logicalResourceId(model.logicalResourceId);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.warnings(model.warnings);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final Map<String, String> getResourceIdentifier() {
            if (this.resourceIdentifier instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = ResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
        }

        @Override
        public final Builder resourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = ResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(GeneratedTemplateResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final List<WarningDetail.Builder> getWarnings() {
            List<WarningDetail.Builder> result = WarningDetailsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<WarningDetail.BuilderImpl> warnings) {
            this.warnings = WarningDetailsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<WarningDetail> warnings) {
            this.warnings = WarningDetailsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(WarningDetail ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<WarningDetail.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (WarningDetail)((WarningDetail.Builder)WarningDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceDetail build() {
            return new ResourceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetail> {
        public Builder resourceType(String var1);

        public Builder logicalResourceId(String var1);

        public Builder resourceIdentifier(Map<String, String> var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(GeneratedTemplateResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder warnings(Collection<WarningDetail> var1);

        public Builder warnings(WarningDetail ... var1);

        public Builder warnings(Consumer<WarningDetail.Builder> ... var1);
    }
}

