/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateSummary> {
    private static final SdkField<String> GENERATED_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateId").getter(TemplateSummary.getter(TemplateSummary::generatedTemplateId)).setter(TemplateSummary.setter(Builder::generatedTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateId").build()}).build();
    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateName").getter(TemplateSummary.getter(TemplateSummary::generatedTemplateName)).setter(TemplateSummary.setter(Builder::generatedTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TemplateSummary.getter(TemplateSummary::statusAsString)).setter(TemplateSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(TemplateSummary.getter(TemplateSummary::statusReason)).setter(TemplateSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TemplateSummary.getter(TemplateSummary::creationTime)).setter(TemplateSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(TemplateSummary.getter(TemplateSummary::lastUpdatedTime)).setter(TemplateSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfResources").getter(TemplateSummary.getter(TemplateSummary::numberOfResources)).setter(TemplateSummary.setter(Builder::numberOfResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_ID_FIELD, GENERATED_TEMPLATE_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, NUMBER_OF_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String generatedTemplateId;
    private final String generatedTemplateName;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final Integer numberOfResources;

    private TemplateSummary(BuilderImpl builder) {
        this.generatedTemplateId = builder.generatedTemplateId;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.numberOfResources = builder.numberOfResources;
    }

    public final String generatedTemplateId() {
        return this.generatedTemplateId;
    }

    public final String generatedTemplateName() {
        return this.generatedTemplateName;
    }

    public final GeneratedTemplateStatus status() {
        return GeneratedTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Integer numberOfResources() {
        return this.numberOfResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummary)) {
            return false;
        }
        TemplateSummary other = (TemplateSummary)obj;
        return Objects.equals(this.generatedTemplateId(), other.generatedTemplateId()) && Objects.equals(this.generatedTemplateName(), other.generatedTemplateName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.numberOfResources(), other.numberOfResources());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateSummary").add("GeneratedTemplateId", (Object)this.generatedTemplateId()).add("GeneratedTemplateName", (Object)this.generatedTemplateName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("NumberOfResources", (Object)this.numberOfResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeneratedTemplateId": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateId()));
            }
            case "GeneratedTemplateName": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "NumberOfResources": {
                return Optional.ofNullable(clazz.cast(this.numberOfResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummary, T> g) {
        return obj -> g.apply((TemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String generatedTemplateId;
        private String generatedTemplateName;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private Integer numberOfResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummary model) {
            this.generatedTemplateId(model.generatedTemplateId);
            this.generatedTemplateName(model.generatedTemplateName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.numberOfResources(model.numberOfResources);
        }

        public final String getGeneratedTemplateId() {
            return this.generatedTemplateId;
        }

        public final void setGeneratedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
        }

        @Override
        public final Builder generatedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
            return this;
        }

        public final String getGeneratedTemplateName() {
            return this.generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Integer getNumberOfResources() {
            return this.numberOfResources;
        }

        public final void setNumberOfResources(Integer numberOfResources) {
            this.numberOfResources = numberOfResources;
        }

        @Override
        public final Builder numberOfResources(Integer numberOfResources) {
            this.numberOfResources = numberOfResources;
            return this;
        }

        public TemplateSummary build() {
            return new TemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateSummary> {
        public Builder generatedTemplateId(String var1);

        public Builder generatedTemplateName(String var1);

        public Builder status(String var1);

        public Builder status(GeneratedTemplateStatus var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder numberOfResources(Integer var1);
    }
}

