/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse;
import software.amazon.awssdk.services.cloudformation.model.TemplateSummary;

public class ListGeneratedTemplatesIterable
implements SdkIterable<ListGeneratedTemplatesResponse> {
    private final CloudFormationClient client;
    private final ListGeneratedTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGeneratedTemplatesIterable(CloudFormationClient client, ListGeneratedTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGeneratedTemplatesResponseFetcher();
    }

    public Iterator<ListGeneratedTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateSummary> summaries() {
        Function<ListGeneratedTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGeneratedTemplatesResponseFetcher
    implements SyncPageFetcher<ListGeneratedTemplatesResponse> {
        private ListGeneratedTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListGeneratedTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGeneratedTemplatesResponse nextPage(ListGeneratedTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListGeneratedTemplatesIterable.this.client.listGeneratedTemplates(ListGeneratedTemplatesIterable.this.firstRequest);
            }
            return ListGeneratedTemplatesIterable.this.client.listGeneratedTemplates((ListGeneratedTemplatesRequest)((Object)ListGeneratedTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

