/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanStatus;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceScanResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeResourceScanResponse> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceScanId").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::resourceScanId)).setter(DescribeResourceScanResponse.setter(Builder::resourceScanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::statusAsString)).setter(DescribeResourceScanResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::statusReason)).setter(DescribeResourceScanResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::startTime)).setter(DescribeResourceScanResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::endTime)).setter(DescribeResourceScanResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Double> PERCENTAGE_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentageCompleted").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::percentageCompleted)).setter(DescribeResourceScanResponse.setter(Builder::percentageCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleted").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::resourceTypes)).setter(DescribeResourceScanResponse.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RESOURCES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesScanned").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::resourcesScanned)).setter(DescribeResourceScanResponse.setter(Builder::resourcesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesScanned").build()}).build();
    private static final SdkField<Integer> RESOURCES_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesRead").getter(DescribeResourceScanResponse.getter(DescribeResourceScanResponse::resourcesRead)).setter(DescribeResourceScanResponse.setter(Builder::resourcesRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesRead").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETED_FIELD, RESOURCE_TYPES_FIELD, RESOURCES_SCANNED_FIELD, RESOURCES_READ_FIELD));
    private final String resourceScanId;
    private final String status;
    private final String statusReason;
    private final Instant startTime;
    private final Instant endTime;
    private final Double percentageCompleted;
    private final List<String> resourceTypes;
    private final Integer resourcesScanned;
    private final Integer resourcesRead;

    private DescribeResourceScanResponse(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageCompleted = builder.percentageCompleted;
        this.resourceTypes = builder.resourceTypes;
        this.resourcesScanned = builder.resourcesScanned;
        this.resourcesRead = builder.resourcesRead;
    }

    public final String resourceScanId() {
        return this.resourceScanId;
    }

    public final ResourceScanStatus status() {
        return ResourceScanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Double percentageCompleted() {
        return this.percentageCompleted;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final Integer resourcesScanned() {
        return this.resourcesScanned;
    }

    public final Integer resourcesRead() {
        return this.resourcesRead;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesRead());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceScanResponse)) {
            return false;
        }
        DescribeResourceScanResponse other = (DescribeResourceScanResponse)((Object)obj);
        return Objects.equals(this.resourceScanId(), other.resourceScanId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.percentageCompleted(), other.percentageCompleted()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.resourcesScanned(), other.resourcesScanned()) && Objects.equals(this.resourcesRead(), other.resourcesRead());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceScanResponse").add("ResourceScanId", (Object)this.resourceScanId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PercentageCompleted", (Object)this.percentageCompleted()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("ResourcesScanned", (Object)this.resourcesScanned()).add("ResourcesRead", (Object)this.resourcesRead()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanId": {
                return Optional.ofNullable(clazz.cast(this.resourceScanId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "PercentageCompleted": {
                return Optional.ofNullable(clazz.cast(this.percentageCompleted()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "ResourcesScanned": {
                return Optional.ofNullable(clazz.cast(this.resourcesScanned()));
            }
            case "ResourcesRead": {
                return Optional.ofNullable(clazz.cast(this.resourcesRead()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceScanResponse, T> g) {
        return obj -> g.apply((DescribeResourceScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String resourceScanId;
        private String status;
        private String statusReason;
        private Instant startTime;
        private Instant endTime;
        private Double percentageCompleted;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer resourcesScanned;
        private Integer resourcesRead;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceScanResponse model) {
            super(model);
            this.resourceScanId(model.resourceScanId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.percentageCompleted(model.percentageCompleted);
            this.resourceTypes(model.resourceTypes);
            this.resourcesScanned(model.resourcesScanned);
            this.resourcesRead(model.resourcesRead);
        }

        public final String getResourceScanId() {
            return this.resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Double getPercentageCompleted() {
            return this.percentageCompleted;
        }

        public final void setPercentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
        }

        @Override
        public final Builder percentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Integer getResourcesScanned() {
            return this.resourcesScanned;
        }

        public final void setResourcesScanned(Integer resourcesScanned) {
            this.resourcesScanned = resourcesScanned;
        }

        @Override
        public final Builder resourcesScanned(Integer resourcesScanned) {
            this.resourcesScanned = resourcesScanned;
            return this;
        }

        public final Integer getResourcesRead() {
            return this.resourcesRead;
        }

        public final void setResourcesRead(Integer resourcesRead) {
            this.resourcesRead = resourcesRead;
        }

        @Override
        public final Builder resourcesRead(Integer resourcesRead) {
            this.resourcesRead = resourcesRead;
            return this;
        }

        @Override
        public DescribeResourceScanResponse build() {
            return new DescribeResourceScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceScanResponse> {
        public Builder resourceScanId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceScanStatus var1);

        public Builder statusReason(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder percentageCompleted(Double var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder resourcesScanned(Integer var1);

        public Builder resourcesRead(Integer var1);
    }
}

