/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.RegistrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTypeRegistrationResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeTypeRegistrationResponse> {
    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgressStatus").getter(DescribeTypeRegistrationResponse.getter(DescribeTypeRegistrationResponse::progressStatusAsString)).setter(DescribeTypeRegistrationResponse.setter(Builder::progressStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeTypeRegistrationResponse.getter(DescribeTypeRegistrationResponse::description)).setter(DescribeTypeRegistrationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(DescribeTypeRegistrationResponse.getter(DescribeTypeRegistrationResponse::typeArn)).setter(DescribeTypeRegistrationResponse.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionArn").getter(DescribeTypeRegistrationResponse.getter(DescribeTypeRegistrationResponse::typeVersionArn)).setter(DescribeTypeRegistrationResponse.setter(Builder::typeVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_STATUS_FIELD, DESCRIPTION_FIELD, TYPE_ARN_FIELD, TYPE_VERSION_ARN_FIELD));
    private final String progressStatus;
    private final String description;
    private final String typeArn;
    private final String typeVersionArn;

    private DescribeTypeRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.progressStatus = builder.progressStatus;
        this.description = builder.description;
        this.typeArn = builder.typeArn;
        this.typeVersionArn = builder.typeVersionArn;
    }

    public final RegistrationStatus progressStatus() {
        return RegistrationStatus.fromValue(this.progressStatus);
    }

    public final String progressStatusAsString() {
        return this.progressStatus;
    }

    public final String description() {
        return this.description;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final String typeVersionArn() {
        return this.typeVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeRegistrationResponse)) {
            return false;
        }
        DescribeTypeRegistrationResponse other = (DescribeTypeRegistrationResponse)((Object)obj);
        return Objects.equals(this.progressStatusAsString(), other.progressStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.typeVersionArn(), other.typeVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTypeRegistrationResponse").add("ProgressStatus", (Object)this.progressStatusAsString()).add("Description", (Object)this.description()).add("TypeArn", (Object)this.typeArn()).add("TypeVersionArn", (Object)this.typeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressStatus": {
                return Optional.ofNullable(clazz.cast(this.progressStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "TypeVersionArn": {
                return Optional.ofNullable(clazz.cast(this.typeVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeRegistrationResponse, T> g) {
        return obj -> g.apply((DescribeTypeRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String progressStatus;
        private String description;
        private String typeArn;
        private String typeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeRegistrationResponse model) {
            super(model);
            this.progressStatus(model.progressStatus);
            this.description(model.description);
            this.typeArn(model.typeArn);
            this.typeVersionArn(model.typeVersionArn);
        }

        public final String getProgressStatus() {
            return this.progressStatus;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(RegistrationStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getTypeVersionArn() {
            return this.typeVersionArn;
        }

        public final void setTypeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
        }

        @Override
        public final Builder typeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
            return this;
        }

        @Override
        public DescribeTypeRegistrationResponse build() {
            return new DescribeTypeRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTypeRegistrationResponse> {
        public Builder progressStatus(String var1);

        public Builder progressStatus(RegistrationStatus var1);

        public Builder description(String var1);

        public Builder typeArn(String var1);

        public Builder typeVersionArn(String var1);
    }
}

