/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudformation.model.JazzResourceIdentifierPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScannedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScannedResource> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ScannedResource.getter(ScannedResource::resourceType)).setter(ScannedResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ResourceIdentifier").getter(ScannedResource.getter(ScannedResource::resourceIdentifier)).setter(ScannedResource.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MANAGED_BY_STACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagedByStack").getter(ScannedResource.getter(ScannedResource::managedByStack)).setter(ScannedResource.setter(Builder::managedByStack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedByStack").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_IDENTIFIER_FIELD, MANAGED_BY_STACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final Map<String, String> resourceIdentifier;
    private final Boolean managedByStack;

    private ScannedResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.managedByStack = builder.managedByStack;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceIdentifier() {
        return this.resourceIdentifier != null && !(this.resourceIdentifier instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final Boolean managedByStack() {
        return this.managedByStack;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifier() ? this.resourceIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByStack());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScannedResource)) {
            return false;
        }
        ScannedResource other = (ScannedResource)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceIdentifier() == other.hasResourceIdentifier() && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.managedByStack(), other.managedByStack());
    }

    public final String toString() {
        return ToString.builder((String)"ScannedResource").add("ResourceType", (Object)this.resourceType()).add("ResourceIdentifier", this.hasResourceIdentifier() ? this.resourceIdentifier() : null).add("ManagedByStack", (Object)this.managedByStack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ManagedByStack": {
                return Optional.ofNullable(clazz.cast(this.managedByStack()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScannedResource, T> g) {
        return obj -> g.apply((ScannedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private Map<String, String> resourceIdentifier = DefaultSdkAutoConstructMap.getInstance();
        private Boolean managedByStack;

        private BuilderImpl() {
        }

        private BuilderImpl(ScannedResource model) {
            this.resourceType(model.resourceType);
            this.resourceIdentifier(model.resourceIdentifier);
            this.managedByStack(model.managedByStack);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Map<String, String> getResourceIdentifier() {
            if (this.resourceIdentifier instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = JazzResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
        }

        @Override
        public final Builder resourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = JazzResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
            return this;
        }

        public final Boolean getManagedByStack() {
            return this.managedByStack;
        }

        public final void setManagedByStack(Boolean managedByStack) {
            this.managedByStack = managedByStack;
        }

        @Override
        public final Builder managedByStack(Boolean managedByStack) {
            this.managedByStack = managedByStack;
            return this;
        }

        public ScannedResource build() {
            return new ScannedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScannedResource> {
        public Builder resourceType(String var1);

        public Builder resourceIdentifier(Map<String, String> var1);

        public Builder managedByStack(Boolean var1);
    }
}

