/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClientBuilder;
import software.amazon.awssdk.services.cloudformation.CloudFormationServiceClientConfiguration;
import software.amazon.awssdk.services.cloudformation.DefaultCloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.DefaultCloudFormationBaseClientBuilder;
import software.amazon.awssdk.services.cloudformation.endpoints.CloudFormationEndpointProvider;

@SdkInternalApi
final class DefaultCloudFormationAsyncClientBuilder
extends DefaultCloudFormationBaseClientBuilder<CloudFormationAsyncClientBuilder, CloudFormationAsyncClient>
implements CloudFormationAsyncClientBuilder {
    DefaultCloudFormationAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudFormationAsyncClientBuilder endpointProvider(CloudFormationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudFormationAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudFormationAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudFormationServiceClientConfiguration serviceClientConfiguration = CloudFormationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudFormationAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

