/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackDriftDetectionStatus;
import software.amazon.awssdk.services.cloudformation.model.StackDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackDriftDetectionStatusResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackDriftDetectionStatusResponse> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::stackId)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> STACK_DRIFT_DETECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackDriftDetectionId").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::stackDriftDetectionId)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::stackDriftDetectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftDetectionId").build()}).build();
    private static final SdkField<String> STACK_DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackDriftStatus").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::stackDriftStatusAsString)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::stackDriftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftStatus").build()}).build();
    private static final SdkField<String> DETECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectionStatus").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::detectionStatusAsString)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::detectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionStatus").build()}).build();
    private static final SdkField<String> DETECTION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectionStatusReason").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::detectionStatusReason)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::detectionStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionStatusReason").build()}).build();
    private static final SdkField<Integer> DRIFTED_STACK_RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DriftedStackResourceCount").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::driftedStackResourceCount)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::driftedStackResourceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftedStackResourceCount").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(DescribeStackDriftDetectionStatusResponse.getter(DescribeStackDriftDetectionStatusResponse::timestamp)).setter(DescribeStackDriftDetectionStatusResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, STACK_DRIFT_DETECTION_ID_FIELD, STACK_DRIFT_STATUS_FIELD, DETECTION_STATUS_FIELD, DETECTION_STATUS_REASON_FIELD, DRIFTED_STACK_RESOURCE_COUNT_FIELD, TIMESTAMP_FIELD));
    private final String stackId;
    private final String stackDriftDetectionId;
    private final String stackDriftStatus;
    private final String detectionStatus;
    private final String detectionStatusReason;
    private final Integer driftedStackResourceCount;
    private final Instant timestamp;

    private DescribeStackDriftDetectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.stackDriftDetectionId = builder.stackDriftDetectionId;
        this.stackDriftStatus = builder.stackDriftStatus;
        this.detectionStatus = builder.detectionStatus;
        this.detectionStatusReason = builder.detectionStatusReason;
        this.driftedStackResourceCount = builder.driftedStackResourceCount;
        this.timestamp = builder.timestamp;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String stackDriftDetectionId() {
        return this.stackDriftDetectionId;
    }

    public final StackDriftStatus stackDriftStatus() {
        return StackDriftStatus.fromValue(this.stackDriftStatus);
    }

    public final String stackDriftStatusAsString() {
        return this.stackDriftStatus;
    }

    public final StackDriftDetectionStatus detectionStatus() {
        return StackDriftDetectionStatus.fromValue(this.detectionStatus);
    }

    public final String detectionStatusAsString() {
        return this.detectionStatus;
    }

    public final String detectionStatusReason() {
        return this.detectionStatusReason;
    }

    public final Integer driftedStackResourceCount() {
        return this.driftedStackResourceCount;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackDriftDetectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftedStackResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackDriftDetectionStatusResponse)) {
            return false;
        }
        DescribeStackDriftDetectionStatusResponse other = (DescribeStackDriftDetectionStatusResponse)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackDriftDetectionId(), other.stackDriftDetectionId()) && Objects.equals(this.stackDriftStatusAsString(), other.stackDriftStatusAsString()) && Objects.equals(this.detectionStatusAsString(), other.detectionStatusAsString()) && Objects.equals(this.detectionStatusReason(), other.detectionStatusReason()) && Objects.equals(this.driftedStackResourceCount(), other.driftedStackResourceCount()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStackDriftDetectionStatusResponse").add("StackId", (Object)this.stackId()).add("StackDriftDetectionId", (Object)this.stackDriftDetectionId()).add("StackDriftStatus", (Object)this.stackDriftStatusAsString()).add("DetectionStatus", (Object)this.detectionStatusAsString()).add("DetectionStatusReason", (Object)this.detectionStatusReason()).add("DriftedStackResourceCount", (Object)this.driftedStackResourceCount()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "StackDriftDetectionId": {
                return Optional.ofNullable(clazz.cast(this.stackDriftDetectionId()));
            }
            case "StackDriftStatus": {
                return Optional.ofNullable(clazz.cast(this.stackDriftStatusAsString()));
            }
            case "DetectionStatus": {
                return Optional.ofNullable(clazz.cast(this.detectionStatusAsString()));
            }
            case "DetectionStatusReason": {
                return Optional.ofNullable(clazz.cast(this.detectionStatusReason()));
            }
            case "DriftedStackResourceCount": {
                return Optional.ofNullable(clazz.cast(this.driftedStackResourceCount()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackDriftDetectionStatusResponse, T> g) {
        return obj -> g.apply((DescribeStackDriftDetectionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String stackId;
        private String stackDriftDetectionId;
        private String stackDriftStatus;
        private String detectionStatus;
        private String detectionStatusReason;
        private Integer driftedStackResourceCount;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackDriftDetectionStatusResponse model) {
            super(model);
            this.stackId(model.stackId);
            this.stackDriftDetectionId(model.stackDriftDetectionId);
            this.stackDriftStatus(model.stackDriftStatus);
            this.detectionStatus(model.detectionStatus);
            this.detectionStatusReason(model.detectionStatusReason);
            this.driftedStackResourceCount(model.driftedStackResourceCount);
            this.timestamp(model.timestamp);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackDriftDetectionId() {
            return this.stackDriftDetectionId;
        }

        public final void setStackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
        }

        @Override
        public final Builder stackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
            return this;
        }

        public final String getStackDriftStatus() {
            return this.stackDriftStatus;
        }

        public final void setStackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
        }

        @Override
        public final Builder stackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
            return this;
        }

        @Override
        public final Builder stackDriftStatus(StackDriftStatus stackDriftStatus) {
            this.stackDriftStatus(stackDriftStatus == null ? null : stackDriftStatus.toString());
            return this;
        }

        public final String getDetectionStatus() {
            return this.detectionStatus;
        }

        public final void setDetectionStatus(String detectionStatus) {
            this.detectionStatus = detectionStatus;
        }

        @Override
        public final Builder detectionStatus(String detectionStatus) {
            this.detectionStatus = detectionStatus;
            return this;
        }

        @Override
        public final Builder detectionStatus(StackDriftDetectionStatus detectionStatus) {
            this.detectionStatus(detectionStatus == null ? null : detectionStatus.toString());
            return this;
        }

        public final String getDetectionStatusReason() {
            return this.detectionStatusReason;
        }

        public final void setDetectionStatusReason(String detectionStatusReason) {
            this.detectionStatusReason = detectionStatusReason;
        }

        @Override
        public final Builder detectionStatusReason(String detectionStatusReason) {
            this.detectionStatusReason = detectionStatusReason;
            return this;
        }

        public final Integer getDriftedStackResourceCount() {
            return this.driftedStackResourceCount;
        }

        public final void setDriftedStackResourceCount(Integer driftedStackResourceCount) {
            this.driftedStackResourceCount = driftedStackResourceCount;
        }

        @Override
        public final Builder driftedStackResourceCount(Integer driftedStackResourceCount) {
            this.driftedStackResourceCount = driftedStackResourceCount;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public DescribeStackDriftDetectionStatusResponse build() {
            return new DescribeStackDriftDetectionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackDriftDetectionStatusResponse> {
        public Builder stackId(String var1);

        public Builder stackDriftDetectionId(String var1);

        public Builder stackDriftStatus(String var1);

        public Builder stackDriftStatus(StackDriftStatus var1);

        public Builder detectionStatus(String var1);

        public Builder detectionStatus(StackDriftDetectionStatus var1);

        public Builder detectionStatusReason(String var1);

        public Builder driftedStackResourceCount(Integer var1);

        public Builder timestamp(Instant var1);
    }
}

