/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetTemplateSummary</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateSummaryResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetTemplateSummaryResponse.Builder, GetTemplateSummaryResponse> {
    private static final SdkField<List<ParameterDeclaration>> PARAMETERS_FIELD = SdkField
            .<List<ParameterDeclaration>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(GetTemplateSummaryResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetTemplateSummaryResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(GetTemplateSummaryResponse::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CAPABILITIES_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapabilitiesReason").getter(getter(GetTemplateSummaryResponse::capabilitiesReason))
            .setter(setter(Builder::capabilitiesReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitiesReason").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(GetTemplateSummaryResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(GetTemplateSummaryResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(GetTemplateSummaryResponse::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<List<String>> DECLARED_TRANSFORMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeclaredTransforms")
            .getter(getter(GetTemplateSummaryResponse::declaredTransforms))
            .setter(setter(Builder::declaredTransforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeclaredTransforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceIdentifierSummary>> RESOURCE_IDENTIFIER_SUMMARIES_FIELD = SdkField
            .<List<ResourceIdentifierSummary>> builder(MarshallingType.LIST)
            .memberName("ResourceIdentifierSummaries")
            .getter(getter(GetTemplateSummaryResponse::resourceIdentifierSummaries))
            .setter(setter(Builder::resourceIdentifierSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifierSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceIdentifierSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceIdentifierSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD,
            DESCRIPTION_FIELD, CAPABILITIES_FIELD, CAPABILITIES_REASON_FIELD, RESOURCE_TYPES_FIELD, VERSION_FIELD,
            METADATA_FIELD, DECLARED_TRANSFORMS_FIELD, RESOURCE_IDENTIFIER_SUMMARIES_FIELD));

    private final List<ParameterDeclaration> parameters;

    private final String description;

    private final List<String> capabilities;

    private final String capabilitiesReason;

    private final List<String> resourceTypes;

    private final String version;

    private final String metadata;

    private final List<String> declaredTransforms;

    private final List<ResourceIdentifierSummary> resourceIdentifierSummaries;

    private GetTemplateSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.resourceTypes = builder.resourceTypes;
        this.version = builder.version;
        this.metadata = builder.metadata;
        this.declaredTransforms = builder.declaredTransforms;
        this.resourceIdentifierSummaries = builder.resourceIdentifierSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter declarations that describe various properties for each parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameter declarations that describe various properties for each parameter.
     */
    public final List<ParameterDeclaration> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The value that's defined in the <code>Description</code> property of the template.
     * </p>
     * 
     * @return The value that's defined in the <code>Description</code> property of the template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
     * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use
     *         the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
     *         an <code>InsufficientCapabilities</code> error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in CloudFormation Templates</a>.
     */
    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities found within the template. If your template contains IAM resources, you must specify the
     * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
     * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities found within the template. If your template contains IAM resources, you must specify the
     *         <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use
     *         the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return
     *         an <code>InsufficientCapabilities</code> error.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in CloudFormation Templates</a>.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The list of resources that generated the values in the <code>Capabilities</code> response element.
     * </p>
     * 
     * @return The list of resources that generated the values in the <code>Capabilities</code> response element.
     */
    public final String capabilitiesReason() {
        return capabilitiesReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the template resource types that are defined in the template, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return A list of all the template resource types that are defined in the template, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
     *         <code>Custom::MyCustomInstance</code>.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Web Services template format version, which identifies the capabilities of the template.
     * </p>
     * 
     * @return The Amazon Web Services template format version, which identifies the capabilities of the template.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The value that's defined for the <code>Metadata</code> property of the template.
     * </p>
     * 
     * @return The value that's defined for the <code>Metadata</code> property of the template.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeclaredTransforms property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeclaredTransforms() {
        return declaredTransforms != null && !(declaredTransforms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the transforms that are declared in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeclaredTransforms} method.
     * </p>
     * 
     * @return A list of the transforms that are declared in the template.
     */
    public final List<String> declaredTransforms() {
        return declaredTransforms;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIdentifierSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceIdentifierSummaries() {
        return resourceIdentifierSummaries != null && !(resourceIdentifierSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource identifier summaries that describe the target resources of an import operation and the
     * properties you can provide during the import to identify the target resources. For example,
     * <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIdentifierSummaries} method.
     * </p>
     * 
     * @return A list of resource identifier summaries that describe the target resources of an import operation and the
     *         properties you can provide during the import to identify the target resources. For example,
     *         <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource.
     */
    public final List<ResourceIdentifierSummary> resourceIdentifierSummaries() {
        return resourceIdentifierSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeclaredTransforms() ? declaredTransforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIdentifierSummaries() ? resourceIdentifierSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResponse)) {
            return false;
        }
        GetTemplateSummaryResponse other = (GetTemplateSummaryResponse) obj;
        return hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(description(), other.description()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(capabilitiesReason(), other.capabilitiesReason())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(version(), other.version()) && Objects.equals(metadata(), other.metadata())
                && hasDeclaredTransforms() == other.hasDeclaredTransforms()
                && Objects.equals(declaredTransforms(), other.declaredTransforms())
                && hasResourceIdentifierSummaries() == other.hasResourceIdentifierSummaries()
                && Objects.equals(resourceIdentifierSummaries(), other.resourceIdentifierSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateSummaryResponse").add("Parameters", hasParameters() ? parameters() : null)
                .add("Description", description()).add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("CapabilitiesReason", capabilitiesReason())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("Version", version())
                .add("Metadata", metadata()).add("DeclaredTransforms", hasDeclaredTransforms() ? declaredTransforms() : null)
                .add("ResourceIdentifierSummaries", hasResourceIdentifierSummaries() ? resourceIdentifierSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "CapabilitiesReason":
            return Optional.ofNullable(clazz.cast(capabilitiesReason()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "DeclaredTransforms":
            return Optional.ofNullable(clazz.cast(declaredTransforms()));
        case "ResourceIdentifierSummaries":
            return Optional.ofNullable(clazz.cast(resourceIdentifierSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryResponse, T> g) {
        return obj -> g.apply((GetTemplateSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemplateSummaryResponse> {
        /**
         * <p>
         * A list of parameter declarations that describe various properties for each parameter.
         * </p>
         * 
         * @param parameters
         *        A list of parameter declarations that describe various properties for each parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterDeclaration> parameters);

        /**
         * <p>
         * A list of parameter declarations that describe various properties for each parameter.
         * </p>
         * 
         * @param parameters
         *        A list of parameter declarations that describe various properties for each parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterDeclaration... parameters);

        /**
         * <p>
         * A list of parameter declarations that describe various properties for each parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<ParameterDeclaration>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<ParameterDeclaration>)
         */
        Builder parameters(Consumer<ParameterDeclaration.Builder>... parameters);

        /**
         * <p>
         * The value that's defined in the <code>Description</code> property of the template.
         * </p>
         * 
         * @param description
         *        The value that's defined in the <code>Description</code> property of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
         * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you
         *        use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions
         *        return an <code>InsufficientCapabilities</code> error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
         * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you
         *        use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions
         *        return an <code>InsufficientCapabilities</code> error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
         * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you
         *        use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions
         *        return an <code>InsufficientCapabilities</code> error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * The capabilities found within the template. If your template contains IAM resources, you must specify the
         * <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you use the
         * <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * 
         * @param capabilities
         *        The capabilities found within the template. If your template contains IAM resources, you must specify
         *        the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> value for this parameter when you
         *        use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions
         *        return an <code>InsufficientCapabilities</code> error.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The list of resources that generated the values in the <code>Capabilities</code> response element.
         * </p>
         * 
         * @param capabilitiesReason
         *        The list of resources that generated the values in the <code>Capabilities</code> response element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesReason(String capabilitiesReason);

        /**
         * <p>
         * A list of all the template resource types that are defined in the template, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        A list of all the template resource types that are defined in the template, such as
         *        <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
         *        <code>Custom::MyCustomInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * A list of all the template resource types that are defined in the template, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        A list of all the template resource types that are defined in the template, such as
         *        <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and
         *        <code>Custom::MyCustomInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Web Services template format version, which identifies the capabilities of the template.
         * </p>
         * 
         * @param version
         *        The Amazon Web Services template format version, which identifies the capabilities of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The value that's defined for the <code>Metadata</code> property of the template.
         * </p>
         * 
         * @param metadata
         *        The value that's defined for the <code>Metadata</code> property of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(Collection<String> declaredTransforms);

        /**
         * <p>
         * A list of the transforms that are declared in the template.
         * </p>
         * 
         * @param declaredTransforms
         *        A list of the transforms that are declared in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declaredTransforms(String... declaredTransforms);

        /**
         * <p>
         * A list of resource identifier summaries that describe the target resources of an import operation and the
         * properties you can provide during the import to identify the target resources. For example,
         * <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource.
         * </p>
         * 
         * @param resourceIdentifierSummaries
         *        A list of resource identifier summaries that describe the target resources of an import operation and
         *        the properties you can provide during the import to identify the target resources. For example,
         *        <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code>
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifierSummaries(Collection<ResourceIdentifierSummary> resourceIdentifierSummaries);

        /**
         * <p>
         * A list of resource identifier summaries that describe the target resources of an import operation and the
         * properties you can provide during the import to identify the target resources. For example,
         * <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource.
         * </p>
         * 
         * @param resourceIdentifierSummaries
         *        A list of resource identifier summaries that describe the target resources of an import operation and
         *        the properties you can provide during the import to identify the target resources. For example,
         *        <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code>
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifierSummaries(ResourceIdentifierSummary... resourceIdentifierSummaries);

        /**
         * <p>
         * A list of resource identifier summaries that describe the target resources of an import operation and the
         * properties you can provide during the import to identify the target resources. For example,
         * <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #resourceIdentifierSummaries(List<ResourceIdentifierSummary>)}.
         * 
         * @param resourceIdentifierSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifierSummaries(java.util.Collection<ResourceIdentifierSummary>)
         */
        Builder resourceIdentifierSummaries(Consumer<ResourceIdentifierSummary.Builder>... resourceIdentifierSummaries);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<ParameterDeclaration> parameters = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String capabilitiesReason;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String version;

        private String metadata;

        private List<String> declaredTransforms = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceIdentifierSummary> resourceIdentifierSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryResponse model) {
            super(model);
            parameters(model.parameters);
            description(model.description);
            capabilitiesWithStrings(model.capabilities);
            capabilitiesReason(model.capabilitiesReason);
            resourceTypes(model.resourceTypes);
            version(model.version);
            metadata(model.metadata);
            declaredTransforms(model.declaredTransforms);
            resourceIdentifierSummaries(model.resourceIdentifierSummaries);
        }

        public final List<ParameterDeclaration.Builder> getParameters() {
            List<ParameterDeclaration.Builder> result = ParameterDeclarationsCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ParameterDeclaration.BuilderImpl> parameters) {
            this.parameters = ParameterDeclarationsCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterDeclaration... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ParameterDeclaration.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ParameterDeclaration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getCapabilitiesReason() {
            return capabilitiesReason;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Collection<String> getDeclaredTransforms() {
            if (declaredTransforms instanceof SdkAutoConstructList) {
                return null;
            }
            return declaredTransforms;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String... declaredTransforms) {
            declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final List<ResourceIdentifierSummary.Builder> getResourceIdentifierSummaries() {
            List<ResourceIdentifierSummary.Builder> result = ResourceIdentifierSummariesCopier
                    .copyToBuilder(this.resourceIdentifierSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifierSummaries(
                Collection<ResourceIdentifierSummary.BuilderImpl> resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries = ResourceIdentifierSummariesCopier.copyFromBuilder(resourceIdentifierSummaries);
        }

        @Override
        public final Builder resourceIdentifierSummaries(Collection<ResourceIdentifierSummary> resourceIdentifierSummaries) {
            this.resourceIdentifierSummaries = ResourceIdentifierSummariesCopier.copy(resourceIdentifierSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifierSummaries(ResourceIdentifierSummary... resourceIdentifierSummaries) {
            resourceIdentifierSummaries(Arrays.asList(resourceIdentifierSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifierSummaries(
                Consumer<ResourceIdentifierSummary.Builder>... resourceIdentifierSummaries) {
            resourceIdentifierSummaries(Stream.of(resourceIdentifierSummaries)
                    .map(c -> ResourceIdentifierSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTemplateSummaryResponse build() {
            return new GetTemplateSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
