/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResource;
import software.amazon.awssdk.services.cloudformation.model.StackResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackResourcesResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackResourcesResponse> {
    private static final SdkField<List<StackResource>> STACK_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackResources").getter(DescribeStackResourcesResponse.getter(DescribeStackResourcesResponse::stackResources)).setter(DescribeStackResourcesResponse.setter(Builder::stackResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCES_FIELD));
    private final List<StackResource> stackResources;

    private DescribeStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResources = builder.stackResources;
    }

    public final boolean hasStackResources() {
        return this.stackResources != null && !(this.stackResources instanceof SdkAutoConstructList);
    }

    public final List<StackResource> stackResources() {
        return this.stackResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackResources() ? this.stackResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesResponse)) {
            return false;
        }
        DescribeStackResourcesResponse other = (DescribeStackResourcesResponse)((Object)obj);
        return this.hasStackResources() == other.hasStackResources() && Objects.equals(this.stackResources(), other.stackResources());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStackResourcesResponse").add("StackResources", this.hasStackResources() ? this.stackResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResources": {
                return Optional.ofNullable(clazz.cast(this.stackResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourcesResponse, T> g) {
        return obj -> g.apply((DescribeStackResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackResource> stackResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesResponse model) {
            super(model);
            this.stackResources(model.stackResources);
        }

        public final List<StackResource.Builder> getStackResources() {
            List<StackResource.Builder> result = StackResourcesCopier.copyToBuilder(this.stackResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(StackResource ... stackResources) {
            this.stackResources(Arrays.asList(stackResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(Consumer<StackResource.Builder> ... stackResources) {
            this.stackResources(Stream.of(stackResources).map(c -> (StackResource)((StackResource.Builder)StackResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStackResources(Collection<StackResource.BuilderImpl> stackResources) {
            this.stackResources = StackResourcesCopier.copyFromBuilder(stackResources);
        }

        @Override
        public DescribeStackResourcesResponse build() {
            return new DescribeStackResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackResourcesResponse> {
        public Builder stackResources(Collection<StackResource> var1);

        public Builder stackResources(StackResource ... var1);

        public Builder stackResources(Consumer<StackResource.Builder> ... var1);
    }
}

