/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetObjectInformationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetObjectInformationResponse> {
    private static final SdkField<List<SchemaFacet>> SCHEMA_FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaFacets").getter(BatchGetObjectInformationResponse.getter(BatchGetObjectInformationResponse::schemaFacets)).setter(BatchGetObjectInformationResponse.setter(Builder::schemaFacets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectIdentifier").getter(BatchGetObjectInformationResponse.getter(BatchGetObjectInformationResponse::objectIdentifier)).setter(BatchGetObjectInformationResponse.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FACETS_FIELD, OBJECT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetObjectInformationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SchemaFacet> schemaFacets;
    private final String objectIdentifier;

    private BatchGetObjectInformationResponse(BuilderImpl builder) {
        this.schemaFacets = builder.schemaFacets;
        this.objectIdentifier = builder.objectIdentifier;
    }

    public final boolean hasSchemaFacets() {
        return this.schemaFacets != null && !(this.schemaFacets instanceof SdkAutoConstructList);
    }

    public final List<SchemaFacet> schemaFacets() {
        return this.schemaFacets;
    }

    public final String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaFacets() ? this.schemaFacets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetObjectInformationResponse)) {
            return false;
        }
        BatchGetObjectInformationResponse other = (BatchGetObjectInformationResponse)obj;
        return this.hasSchemaFacets() == other.hasSchemaFacets() && Objects.equals(this.schemaFacets(), other.schemaFacets()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetObjectInformationResponse").add("SchemaFacets", this.hasSchemaFacets() ? this.schemaFacets() : null).add("ObjectIdentifier", (Object)this.objectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaFacets": {
                return Optional.ofNullable(clazz.cast(this.schemaFacets()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaFacets", SCHEMA_FACETS_FIELD);
        map.put("ObjectIdentifier", OBJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetObjectInformationResponse, T> g) {
        return obj -> g.apply((BatchGetObjectInformationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SchemaFacet> schemaFacets = DefaultSdkAutoConstructList.getInstance();
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetObjectInformationResponse model) {
            this.schemaFacets(model.schemaFacets);
            this.objectIdentifier(model.objectIdentifier);
        }

        public final List<SchemaFacet.Builder> getSchemaFacets() {
            List<SchemaFacet.Builder> result = SchemaFacetListCopier.copyToBuilder(this.schemaFacets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaFacets(Collection<SchemaFacet.BuilderImpl> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copyFromBuilder(schemaFacets);
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet ... schemaFacets) {
            this.schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(Consumer<SchemaFacet.Builder> ... schemaFacets) {
            this.schemaFacets(Stream.of(schemaFacets).map(c -> (SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public BatchGetObjectInformationResponse build() {
            return new BatchGetObjectInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetObjectInformationResponse> {
        public Builder schemaFacets(Collection<SchemaFacet> var1);

        public Builder schemaFacets(SchemaFacet ... var1);

        public Builder schemaFacets(Consumer<SchemaFacet.Builder> ... var1);

        public Builder objectIdentifier(String var1);
    }
}

