/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponseListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReadResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, BatchReadResponse> {
    private static final SdkField<List<BatchReadOperationResponse>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Responses").getter(BatchReadResponse.getter(BatchReadResponse::responses)).setter(BatchReadResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchReadOperationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchReadResponse.memberNameToFieldInitializer();
    private final List<BatchReadOperationResponse> responses;

    private BatchReadResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public final List<BatchReadOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadResponse)) {
            return false;
        }
        BatchReadResponse other = (BatchReadResponse)((Object)obj);
        return this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses());
    }

    public final String toString() {
        return ToString.builder((String)"BatchReadResponse").add("Responses", this.hasResponses() ? this.responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchReadOperationResponse>>> map = new HashMap<String, SdkField<List<BatchReadOperationResponse>>>();
        map.put("Responses", RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchReadResponse, T> g) {
        return obj -> g.apply((BatchReadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<BatchReadOperationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadResponse model) {
            super(model);
            this.responses(model.responses);
        }

        public final List<BatchReadOperationResponse.Builder> getResponses() {
            List<BatchReadOperationResponse.Builder> result = BatchReadOperationResponseListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<BatchReadOperationResponse.BuilderImpl> responses) {
            this.responses = BatchReadOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Collection<BatchReadOperationResponse> responses) {
            this.responses = BatchReadOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchReadOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<BatchReadOperationResponse.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (BatchReadOperationResponse)((BatchReadOperationResponse.Builder)BatchReadOperationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchReadResponse build() {
            return new BatchReadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchReadResponse> {
        public Builder responses(Collection<BatchReadOperationResponse> var1);

        public Builder responses(BatchReadOperationResponse ... var1);

        public Builder responses(Consumer<BatchReadOperationResponse.Builder> ... var1);
    }
}

