/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceResponse
extends CloudControlResponse
implements ToCopyableBuilder<Builder, CreateResourceResponse> {
    private static final SdkField<ProgressEvent> PROGRESS_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressEvent").getter(CreateResourceResponse.getter(CreateResourceResponse::progressEvent)).setter(CreateResourceResponse.setter(Builder::progressEvent)).constructor(ProgressEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceResponse.memberNameToFieldInitializer();
    private final ProgressEvent progressEvent;

    private CreateResourceResponse(BuilderImpl builder) {
        super(builder);
        this.progressEvent = builder.progressEvent;
    }

    public final ProgressEvent progressEvent() {
        return this.progressEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.progressEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceResponse)) {
            return false;
        }
        CreateResourceResponse other = (CreateResourceResponse)((Object)obj);
        return Objects.equals(this.progressEvent(), other.progressEvent());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceResponse").add("ProgressEvent", (Object)this.progressEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressEvent": {
                return Optional.ofNullable(clazz.cast(this.progressEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ProgressEvent>> map = new HashMap<String, SdkField<ProgressEvent>>();
        map.put("ProgressEvent", PROGRESS_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceResponse, T> g) {
        return obj -> g.apply((CreateResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlResponse.BuilderImpl
    implements Builder {
        private ProgressEvent progressEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceResponse model) {
            super(model);
            this.progressEvent(model.progressEvent);
        }

        public final ProgressEvent.Builder getProgressEvent() {
            return this.progressEvent != null ? this.progressEvent.toBuilder() : null;
        }

        public final void setProgressEvent(ProgressEvent.BuilderImpl progressEvent) {
            this.progressEvent = progressEvent != null ? progressEvent.build() : null;
        }

        @Override
        public final Builder progressEvent(ProgressEvent progressEvent) {
            this.progressEvent = progressEvent;
            return this;
        }

        @Override
        public CreateResourceResponse build() {
            return new CreateResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceResponse> {
        public Builder progressEvent(ProgressEvent var1);

        default public Builder progressEvent(Consumer<ProgressEvent.Builder> progressEvent) {
            return this.progressEvent((ProgressEvent)((ProgressEvent.Builder)ProgressEvent.builder().applyMutation(progressEvent)).build());
        }
    }
}

