/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainedModelInferenceJobsRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, ListTrainedModelInferenceJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrainedModelInferenceJobsRequest.getter(ListTrainedModelInferenceJobsRequest::nextToken)).setter(ListTrainedModelInferenceJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTrainedModelInferenceJobsRequest.getter(ListTrainedModelInferenceJobsRequest::maxResults)).setter(ListTrainedModelInferenceJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(ListTrainedModelInferenceJobsRequest.getter(ListTrainedModelInferenceJobsRequest::membershipIdentifier)).setter(ListTrainedModelInferenceJobsRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(ListTrainedModelInferenceJobsRequest.getter(ListTrainedModelInferenceJobsRequest::trainedModelArn)).setter(ListTrainedModelInferenceJobsRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_VERSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelVersionIdentifier").getter(ListTrainedModelInferenceJobsRequest.getter(ListTrainedModelInferenceJobsRequest::trainedModelVersionIdentifier)).setter(ListTrainedModelInferenceJobsRequest.setter(Builder::trainedModelVersionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trainedModelVersionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_VERSION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainedModelInferenceJobsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String membershipIdentifier;
    private final String trainedModelArn;
    private final String trainedModelVersionIdentifier;

    private ListTrainedModelInferenceJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelVersionIdentifier = builder.trainedModelVersionIdentifier;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String trainedModelVersionIdentifier() {
        return this.trainedModelVersionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelVersionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainedModelInferenceJobsRequest)) {
            return false;
        }
        ListTrainedModelInferenceJobsRequest other = (ListTrainedModelInferenceJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.trainedModelVersionIdentifier(), other.trainedModelVersionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainedModelInferenceJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("TrainedModelVersionIdentifier", (Object)this.trainedModelVersionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "trainedModelVersionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.trainedModelVersionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("trainedModelVersionIdentifier", TRAINED_MODEL_VERSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainedModelInferenceJobsRequest, T> g) {
        return obj -> g.apply((ListTrainedModelInferenceJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String membershipIdentifier;
        private String trainedModelArn;
        private String trainedModelVersionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainedModelInferenceJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.membershipIdentifier(model.membershipIdentifier);
            this.trainedModelArn(model.trainedModelArn);
            this.trainedModelVersionIdentifier(model.trainedModelVersionIdentifier);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getTrainedModelVersionIdentifier() {
            return this.trainedModelVersionIdentifier;
        }

        public final void setTrainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
        }

        @Override
        public final Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainedModelInferenceJobsRequest build() {
            return new ListTrainedModelInferenceJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainedModelInferenceJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder membershipIdentifier(String var1);

        public Builder trainedModelArn(String var1);

        public Builder trainedModelVersionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

