/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.AccessBudgetType;
import software.amazon.awssdk.services.cleanroomsml.model.AutoRefreshMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessBudgetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessBudgetDetails> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AccessBudgetDetails.getter(AccessBudgetDetails::startTime)).setter(AccessBudgetDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AccessBudgetDetails.getter(AccessBudgetDetails::endTime)).setter(AccessBudgetDetails.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> REMAINING_BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("remainingBudget").getter(AccessBudgetDetails.getter(AccessBudgetDetails::remainingBudget)).setter(AccessBudgetDetails.setter(Builder::remainingBudget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remainingBudget").build()}).build();
    private static final SdkField<Integer> BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("budget").getter(AccessBudgetDetails.getter(AccessBudgetDetails::budget)).setter(AccessBudgetDetails.setter(Builder::budget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budget").build()}).build();
    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("budgetType").getter(AccessBudgetDetails.getter(AccessBudgetDetails::budgetTypeAsString)).setter(AccessBudgetDetails.setter(Builder::budgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetType").build()}).build();
    private static final SdkField<String> AUTO_REFRESH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoRefresh").getter(AccessBudgetDetails.getter(AccessBudgetDetails::autoRefreshAsString)).setter(AccessBudgetDetails.setter(Builder::autoRefresh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRefresh").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, REMAINING_BUDGET_FIELD, BUDGET_FIELD, BUDGET_TYPE_FIELD, AUTO_REFRESH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessBudgetDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer remainingBudget;
    private final Integer budget;
    private final String budgetType;
    private final String autoRefresh;

    private AccessBudgetDetails(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.remainingBudget = builder.remainingBudget;
        this.budget = builder.budget;
        this.budgetType = builder.budgetType;
        this.autoRefresh = builder.autoRefresh;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer remainingBudget() {
        return this.remainingBudget;
    }

    public final Integer budget() {
        return this.budget;
    }

    public final AccessBudgetType budgetType() {
        return AccessBudgetType.fromValue(this.budgetType);
    }

    public final String budgetTypeAsString() {
        return this.budgetType;
    }

    public final AutoRefreshMode autoRefresh() {
        return AutoRefreshMode.fromValue(this.autoRefresh);
    }

    public final String autoRefreshAsString() {
        return this.autoRefresh;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingBudget());
        hashCode = 31 * hashCode + Objects.hashCode(this.budget());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRefreshAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudgetDetails)) {
            return false;
        }
        AccessBudgetDetails other = (AccessBudgetDetails)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.remainingBudget(), other.remainingBudget()) && Objects.equals(this.budget(), other.budget()) && Objects.equals(this.budgetTypeAsString(), other.budgetTypeAsString()) && Objects.equals(this.autoRefreshAsString(), other.autoRefreshAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessBudgetDetails").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("RemainingBudget", (Object)this.remainingBudget()).add("Budget", (Object)this.budget()).add("BudgetType", (Object)this.budgetTypeAsString()).add("AutoRefresh", (Object)this.autoRefreshAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "remainingBudget": {
                return Optional.ofNullable(clazz.cast(this.remainingBudget()));
            }
            case "budget": {
                return Optional.ofNullable(clazz.cast(this.budget()));
            }
            case "budgetType": {
                return Optional.ofNullable(clazz.cast(this.budgetTypeAsString()));
            }
            case "autoRefresh": {
                return Optional.ofNullable(clazz.cast(this.autoRefreshAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("remainingBudget", REMAINING_BUDGET_FIELD);
        map.put("budget", BUDGET_FIELD);
        map.put("budgetType", BUDGET_TYPE_FIELD);
        map.put("autoRefresh", AUTO_REFRESH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudgetDetails, T> g) {
        return obj -> g.apply((AccessBudgetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private Integer remainingBudget;
        private Integer budget;
        private String budgetType;
        private String autoRefresh;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudgetDetails model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.remainingBudget(model.remainingBudget);
            this.budget(model.budget);
            this.budgetType(model.budgetType);
            this.autoRefresh(model.autoRefresh);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getRemainingBudget() {
            return this.remainingBudget;
        }

        public final void setRemainingBudget(Integer remainingBudget) {
            this.remainingBudget = remainingBudget;
        }

        @Override
        public final Builder remainingBudget(Integer remainingBudget) {
            this.remainingBudget = remainingBudget;
            return this;
        }

        public final Integer getBudget() {
            return this.budget;
        }

        public final void setBudget(Integer budget) {
            this.budget = budget;
        }

        @Override
        public final Builder budget(Integer budget) {
            this.budget = budget;
            return this;
        }

        public final String getBudgetType() {
            return this.budgetType;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(AccessBudgetType budgetType) {
            this.budgetType(budgetType == null ? null : budgetType.toString());
            return this;
        }

        public final String getAutoRefresh() {
            return this.autoRefresh;
        }

        public final void setAutoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        @Override
        public final Builder autoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public final Builder autoRefresh(AutoRefreshMode autoRefresh) {
            this.autoRefresh(autoRefresh == null ? null : autoRefresh.toString());
            return this;
        }

        public AccessBudgetDetails build() {
            return new AccessBudgetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessBudgetDetails> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder remainingBudget(Integer var1);

        public Builder budget(Integer var1);

        public Builder budgetType(String var1);

        public Builder budgetType(AccessBudgetType var1);

        public Builder autoRefresh(String var1);

        public Builder autoRefresh(AutoRefreshMode var1);
    }
}

