/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;

public class ListCollaborationTrainedModelInferenceJobsPublisher
implements SdkPublisher<ListCollaborationTrainedModelInferenceJobsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListCollaborationTrainedModelInferenceJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationTrainedModelInferenceJobsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelInferenceJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationTrainedModelInferenceJobsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelInferenceJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationTrainedModelInferenceJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationTrainedModelInferenceJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs() {
        Function<ListCollaborationTrainedModelInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModelInferenceJobs() != null) {
                return response.collaborationTrainedModelInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationTrainedModelInferenceJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationTrainedModelInferenceJobsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationTrainedModelInferenceJobsResponse> {
        private ListCollaborationTrainedModelInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> nextPage(ListCollaborationTrainedModelInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelInferenceJobsPublisher.this.client.listCollaborationTrainedModelInferenceJobs(ListCollaborationTrainedModelInferenceJobsPublisher.this.firstRequest);
            }
            return ListCollaborationTrainedModelInferenceJobsPublisher.this.client.listCollaborationTrainedModelInferenceJobs((ListCollaborationTrainedModelInferenceJobsRequest)((Object)ListCollaborationTrainedModelInferenceJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

