/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfiguredModelAlgorithmsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListConfiguredModelAlgorithmsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConfiguredModelAlgorithmsResponse.getter(ListConfiguredModelAlgorithmsResponse::nextToken)).setter(ListConfiguredModelAlgorithmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ConfiguredModelAlgorithmSummary>> CONFIGURED_MODEL_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithms").getter(ListConfiguredModelAlgorithmsResponse.getter(ListConfiguredModelAlgorithmsResponse::configuredModelAlgorithms)).setter(ListConfiguredModelAlgorithmsResponse.setter(Builder::configuredModelAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfiguredModelAlgorithmSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONFIGURED_MODEL_ALGORITHMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfiguredModelAlgorithmsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms;

    private ListConfiguredModelAlgorithmsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.configuredModelAlgorithms = builder.configuredModelAlgorithms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConfiguredModelAlgorithms() {
        return this.configuredModelAlgorithms != null && !(this.configuredModelAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms() {
        return this.configuredModelAlgorithms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithms() ? this.configuredModelAlgorithms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfiguredModelAlgorithmsResponse)) {
            return false;
        }
        ListConfiguredModelAlgorithmsResponse other = (ListConfiguredModelAlgorithmsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConfiguredModelAlgorithms() == other.hasConfiguredModelAlgorithms() && Objects.equals(this.configuredModelAlgorithms(), other.configuredModelAlgorithms());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfiguredModelAlgorithmsResponse").add("NextToken", (Object)this.nextToken()).add("ConfiguredModelAlgorithms", this.hasConfiguredModelAlgorithms() ? this.configuredModelAlgorithms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "configuredModelAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("configuredModelAlgorithms", CONFIGURED_MODEL_ALGORITHMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfiguredModelAlgorithmsResponse, T> g) {
        return obj -> g.apply((ListConfiguredModelAlgorithmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfiguredModelAlgorithmsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.configuredModelAlgorithms(model.configuredModelAlgorithms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfiguredModelAlgorithmSummary.Builder> getConfiguredModelAlgorithms() {
            List<ConfiguredModelAlgorithmSummary.Builder> result = ConfiguredModelAlgorithmListCopier.copyToBuilder(this.configuredModelAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredModelAlgorithms(Collection<ConfiguredModelAlgorithmSummary.BuilderImpl> configuredModelAlgorithms) {
            this.configuredModelAlgorithms = ConfiguredModelAlgorithmListCopier.copyFromBuilder(configuredModelAlgorithms);
        }

        @Override
        public final Builder configuredModelAlgorithms(Collection<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms) {
            this.configuredModelAlgorithms = ConfiguredModelAlgorithmListCopier.copy(configuredModelAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithms(ConfiguredModelAlgorithmSummary ... configuredModelAlgorithms) {
            this.configuredModelAlgorithms(Arrays.asList(configuredModelAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithms(Consumer<ConfiguredModelAlgorithmSummary.Builder> ... configuredModelAlgorithms) {
            this.configuredModelAlgorithms(Stream.of(configuredModelAlgorithms).map(c -> (ConfiguredModelAlgorithmSummary)((ConfiguredModelAlgorithmSummary.Builder)ConfiguredModelAlgorithmSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfiguredModelAlgorithmsResponse build() {
            return new ListConfiguredModelAlgorithmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfiguredModelAlgorithmsResponse> {
        public Builder nextToken(String var1);

        public Builder configuredModelAlgorithms(Collection<ConfiguredModelAlgorithmSummary> var1);

        public Builder configuredModelAlgorithms(ConfiguredModelAlgorithmSummary ... var1);

        public Builder configuredModelAlgorithms(Consumer<ConfiguredModelAlgorithmSummary.Builder> ... var1);
    }
}

