/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceExportJobListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceExportJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAudienceExportJobsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListAudienceExportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAudienceExportJobsResponse.getter(ListAudienceExportJobsResponse::nextToken)).setter(ListAudienceExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AudienceExportJobSummary>> AUDIENCE_EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audienceExportJobs").getter(ListAudienceExportJobsResponse.getter(ListAudienceExportJobsResponse::audienceExportJobs)).setter(ListAudienceExportJobsResponse.setter(Builder::audienceExportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudienceExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AUDIENCE_EXPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAudienceExportJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AudienceExportJobSummary> audienceExportJobs;

    private ListAudienceExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.audienceExportJobs = builder.audienceExportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAudienceExportJobs() {
        return this.audienceExportJobs != null && !(this.audienceExportJobs instanceof SdkAutoConstructList);
    }

    public final List<AudienceExportJobSummary> audienceExportJobs() {
        return this.audienceExportJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceExportJobs() ? this.audienceExportJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAudienceExportJobsResponse)) {
            return false;
        }
        ListAudienceExportJobsResponse other = (ListAudienceExportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAudienceExportJobs() == other.hasAudienceExportJobs() && Objects.equals(this.audienceExportJobs(), other.audienceExportJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListAudienceExportJobsResponse").add("NextToken", (Object)this.nextToken()).add("AudienceExportJobs", this.hasAudienceExportJobs() ? this.audienceExportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "audienceExportJobs": {
                return Optional.ofNullable(clazz.cast(this.audienceExportJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("audienceExportJobs", AUDIENCE_EXPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAudienceExportJobsResponse, T> g) {
        return obj -> g.apply((ListAudienceExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AudienceExportJobSummary> audienceExportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAudienceExportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.audienceExportJobs(model.audienceExportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AudienceExportJobSummary.Builder> getAudienceExportJobs() {
            List<AudienceExportJobSummary.Builder> result = AudienceExportJobListCopier.copyToBuilder(this.audienceExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceExportJobs(Collection<AudienceExportJobSummary.BuilderImpl> audienceExportJobs) {
            this.audienceExportJobs = AudienceExportJobListCopier.copyFromBuilder(audienceExportJobs);
        }

        @Override
        public final Builder audienceExportJobs(Collection<AudienceExportJobSummary> audienceExportJobs) {
            this.audienceExportJobs = AudienceExportJobListCopier.copy(audienceExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceExportJobs(AudienceExportJobSummary ... audienceExportJobs) {
            this.audienceExportJobs(Arrays.asList(audienceExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceExportJobs(Consumer<AudienceExportJobSummary.Builder> ... audienceExportJobs) {
            this.audienceExportJobs(Stream.of(audienceExportJobs).map(c -> (AudienceExportJobSummary)((AudienceExportJobSummary.Builder)AudienceExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAudienceExportJobsResponse build() {
            return new ListAudienceExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAudienceExportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder audienceExportJobs(Collection<AudienceExportJobSummary> var1);

        public Builder audienceExportJobs(AudienceExportJobSummary ... var1);

        public Builder audienceExportJobs(Consumer<AudienceExportJobSummary.Builder> ... var1);
    }
}

