/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PrivacyConfiguration;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredModelAlgorithmAssociationRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CreateConfiguredModelAlgorithmAssociationRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::membershipIdentifier)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmArn").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::configuredModelAlgorithmArn)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::configuredModelAlgorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::name)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::description)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PrivacyConfiguration> PRIVACY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("privacyConfiguration").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::privacyConfiguration)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::privacyConfiguration)).constructor(PrivacyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConfiguredModelAlgorithmAssociationRequest.getter(CreateConfiguredModelAlgorithmAssociationRequest::tags)).setter(CreateConfiguredModelAlgorithmAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, CONFIGURED_MODEL_ALGORITHM_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PRIVACY_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConfiguredModelAlgorithmAssociationRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String configuredModelAlgorithmArn;
    private final String name;
    private final String description;
    private final PrivacyConfiguration privacyConfiguration;
    private final Map<String, String> tags;

    private CreateConfiguredModelAlgorithmAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredModelAlgorithmArn = builder.configuredModelAlgorithmArn;
        this.name = builder.name;
        this.description = builder.description;
        this.privacyConfiguration = builder.privacyConfiguration;
        this.tags = builder.tags;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String configuredModelAlgorithmArn() {
        return this.configuredModelAlgorithmArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final PrivacyConfiguration privacyConfiguration() {
        return this.privacyConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredModelAlgorithmAssociationRequest)) {
            return false;
        }
        CreateConfiguredModelAlgorithmAssociationRequest other = (CreateConfiguredModelAlgorithmAssociationRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.configuredModelAlgorithmArn(), other.configuredModelAlgorithmArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.privacyConfiguration(), other.privacyConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredModelAlgorithmAssociationRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("ConfiguredModelAlgorithmArn", (Object)this.configuredModelAlgorithmArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("PrivacyConfiguration", (Object)this.privacyConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "configuredModelAlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "privacyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.privacyConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("configuredModelAlgorithmArn", CONFIGURED_MODEL_ALGORITHM_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("privacyConfiguration", PRIVACY_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredModelAlgorithmAssociationRequest, T> g) {
        return obj -> g.apply((CreateConfiguredModelAlgorithmAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String configuredModelAlgorithmArn;
        private String name;
        private String description;
        private PrivacyConfiguration privacyConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredModelAlgorithmAssociationRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.configuredModelAlgorithmArn(model.configuredModelAlgorithmArn);
            this.name(model.name);
            this.description(model.description);
            this.privacyConfiguration(model.privacyConfiguration);
            this.tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredModelAlgorithmArn() {
            return this.configuredModelAlgorithmArn;
        }

        public final void setConfiguredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
        }

        @Override
        public final Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PrivacyConfiguration.Builder getPrivacyConfiguration() {
            return this.privacyConfiguration != null ? this.privacyConfiguration.toBuilder() : null;
        }

        public final void setPrivacyConfiguration(PrivacyConfiguration.BuilderImpl privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration != null ? privacyConfiguration.build() : null;
        }

        @Override
        public final Builder privacyConfiguration(PrivacyConfiguration privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredModelAlgorithmAssociationRequest build() {
            return new CreateConfiguredModelAlgorithmAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredModelAlgorithmAssociationRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder configuredModelAlgorithmArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder privacyConfiguration(PrivacyConfiguration var1);

        default public Builder privacyConfiguration(Consumer<PrivacyConfiguration.Builder> privacyConfiguration) {
            return this.privacyConfiguration((PrivacyConfiguration)((PrivacyConfiguration.Builder)PrivacyConfiguration.builder().applyMutation(privacyConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

