/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelSummary;

public class ListMLInputChannelsPublisher
implements SdkPublisher<ListMlInputChannelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListMlInputChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMLInputChannelsPublisher(CleanRoomsMlAsyncClient client, ListMlInputChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMLInputChannelsPublisher(CleanRoomsMlAsyncClient client, ListMlInputChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMlInputChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMlInputChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MLInputChannelSummary> mlInputChannelsList() {
        Function<ListMlInputChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mlInputChannelsList() != null) {
                return response.mlInputChannelsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMlInputChannelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMlInputChannelsResponseFetcher
    implements AsyncPageFetcher<ListMlInputChannelsResponse> {
        private ListMlInputChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlInputChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMlInputChannelsResponse> nextPage(ListMlInputChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListMLInputChannelsPublisher.this.client.listMLInputChannels(ListMLInputChannelsPublisher.this.firstRequest);
            }
            return ListMLInputChannelsPublisher.this.client.listMLInputChannels((ListMlInputChannelsRequest)((Object)ListMLInputChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

