/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary;

public class ListTrainedModelsPublisher
implements SdkPublisher<ListTrainedModelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListTrainedModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainedModelsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainedModelsPublisher(CleanRoomsMlAsyncClient client, ListTrainedModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainedModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainedModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainedModelSummary> trainedModels() {
        Function<ListTrainedModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModels() != null) {
                return response.trainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainedModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainedModelsResponseFetcher
    implements AsyncPageFetcher<ListTrainedModelsResponse> {
        private ListTrainedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainedModelsResponse> nextPage(ListTrainedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelsPublisher.this.client.listTrainedModels(ListTrainedModelsPublisher.this.firstRequest);
            }
            return ListTrainedModelsPublisher.this.client.listTrainedModels((ListTrainedModelsRequest)((Object)ListTrainedModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

