/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;

public class ListConfiguredModelAlgorithmAssociationsPublisher
implements SdkPublisher<ListConfiguredModelAlgorithmAssociationsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListConfiguredModelAlgorithmAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredModelAlgorithmAssociationsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredModelAlgorithmAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredModelAlgorithmAssociationsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredModelAlgorithmAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredModelAlgorithmAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredModelAlgorithmAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations() {
        Function<ListConfiguredModelAlgorithmAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredModelAlgorithmAssociations() != null) {
                return response.configuredModelAlgorithmAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredModelAlgorithmAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredModelAlgorithmAssociationsResponseFetcher
    implements AsyncPageFetcher<ListConfiguredModelAlgorithmAssociationsResponse> {
        private ListConfiguredModelAlgorithmAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredModelAlgorithmAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> nextPage(ListConfiguredModelAlgorithmAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredModelAlgorithmAssociationsPublisher.this.client.listConfiguredModelAlgorithmAssociations(ListConfiguredModelAlgorithmAssociationsPublisher.this.firstRequest);
            }
            return ListConfiguredModelAlgorithmAssociationsPublisher.this.client.listConfiguredModelAlgorithmAssociations((ListConfiguredModelAlgorithmAssociationsRequest)((Object)ListConfiguredModelAlgorithmAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

