/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;

public class ListCollaborationTrainedModelsPublisher
implements SdkPublisher<ListCollaborationTrainedModelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListCollaborationTrainedModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationTrainedModelsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationTrainedModelsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationTrainedModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationTrainedModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationTrainedModelSummary> collaborationTrainedModels() {
        Function<ListCollaborationTrainedModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModels() != null) {
                return response.collaborationTrainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationTrainedModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationTrainedModelsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationTrainedModelsResponse> {
        private ListCollaborationTrainedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationTrainedModelsResponse> nextPage(ListCollaborationTrainedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelsPublisher.this.client.listCollaborationTrainedModels(ListCollaborationTrainedModelsPublisher.this.firstRequest);
            }
            return ListCollaborationTrainedModelsPublisher.this.client.listCollaborationTrainedModels((ListCollaborationTrainedModelsRequest)((Object)ListCollaborationTrainedModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

