/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;

public class ListConfiguredModelAlgorithmsIterable
implements SdkIterable<ListConfiguredModelAlgorithmsResponse> {
    private final CleanRoomsMlClient client;
    private final ListConfiguredModelAlgorithmsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredModelAlgorithmsIterable(CleanRoomsMlClient client, ListConfiguredModelAlgorithmsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfiguredModelAlgorithmsResponseFetcher();
    }

    public Iterator<ListConfiguredModelAlgorithmsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms() {
        Function<ListConfiguredModelAlgorithmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredModelAlgorithms() != null) {
                return response.configuredModelAlgorithms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredModelAlgorithmsResponseFetcher
    implements SyncPageFetcher<ListConfiguredModelAlgorithmsResponse> {
        private ListConfiguredModelAlgorithmsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredModelAlgorithmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredModelAlgorithmsResponse nextPage(ListConfiguredModelAlgorithmsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredModelAlgorithmsIterable.this.client.listConfiguredModelAlgorithms(ListConfiguredModelAlgorithmsIterable.this.firstRequest);
            }
            return ListConfiguredModelAlgorithmsIterable.this.client.listConfiguredModelAlgorithms((ListConfiguredModelAlgorithmsRequest)((Object)ListConfiguredModelAlgorithmsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

