/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;

public class ListCollaborationTrainedModelExportJobsIterable
implements SdkIterable<ListCollaborationTrainedModelExportJobsResponse> {
    private final CleanRoomsMlClient client;
    private final ListCollaborationTrainedModelExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationTrainedModelExportJobsIterable(CleanRoomsMlClient client, ListCollaborationTrainedModelExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationTrainedModelExportJobsResponseFetcher();
    }

    public Iterator<ListCollaborationTrainedModelExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs() {
        Function<ListCollaborationTrainedModelExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModelExportJobs() != null) {
                return response.collaborationTrainedModelExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationTrainedModelExportJobsResponseFetcher
    implements SyncPageFetcher<ListCollaborationTrainedModelExportJobsResponse> {
        private ListCollaborationTrainedModelExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationTrainedModelExportJobsResponse nextPage(ListCollaborationTrainedModelExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelExportJobsIterable.this.client.listCollaborationTrainedModelExportJobs(ListCollaborationTrainedModelExportJobsIterable.this.firstRequest);
            }
            return ListCollaborationTrainedModelExportJobsIterable.this.client.listCollaborationTrainedModelExportJobs((ListCollaborationTrainedModelExportJobsRequest)((Object)ListCollaborationTrainedModelExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

