/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ContainerConfig;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceContainerConfig;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfiguredModelAlgorithmResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetConfiguredModelAlgorithmResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::createTime)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::updateTime)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmArn").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::configuredModelAlgorithmArn)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::configuredModelAlgorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::name)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ContainerConfig> TRAINING_CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingContainerConfig").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::trainingContainerConfig)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::trainingContainerConfig)).constructor(ContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingContainerConfig").build()}).build();
    private static final SdkField<InferenceContainerConfig> INFERENCE_CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceContainerConfig").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::inferenceContainerConfig)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::inferenceContainerConfig)).constructor(InferenceContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceContainerConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::roleArn)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::description)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::tags)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetConfiguredModelAlgorithmResponse.getter(GetConfiguredModelAlgorithmResponse::kmsKeyArn)).setter(GetConfiguredModelAlgorithmResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, CONFIGURED_MODEL_ALGORITHM_ARN_FIELD, NAME_FIELD, TRAINING_CONTAINER_CONFIG_FIELD, INFERENCE_CONTAINER_CONFIG_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConfiguredModelAlgorithmResponse.memberNameToFieldInitializer();
    private final Instant createTime;
    private final Instant updateTime;
    private final String configuredModelAlgorithmArn;
    private final String name;
    private final ContainerConfig trainingContainerConfig;
    private final InferenceContainerConfig inferenceContainerConfig;
    private final String roleArn;
    private final String description;
    private final Map<String, String> tags;
    private final String kmsKeyArn;

    private GetConfiguredModelAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredModelAlgorithmArn = builder.configuredModelAlgorithmArn;
        this.name = builder.name;
        this.trainingContainerConfig = builder.trainingContainerConfig;
        this.inferenceContainerConfig = builder.inferenceContainerConfig;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String configuredModelAlgorithmArn() {
        return this.configuredModelAlgorithmArn;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerConfig trainingContainerConfig() {
        return this.trainingContainerConfig;
    }

    public final InferenceContainerConfig inferenceContainerConfig() {
        return this.inferenceContainerConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredModelAlgorithmResponse)) {
            return false;
        }
        GetConfiguredModelAlgorithmResponse other = (GetConfiguredModelAlgorithmResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.configuredModelAlgorithmArn(), other.configuredModelAlgorithmArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.trainingContainerConfig(), other.trainingContainerConfig()) && Objects.equals(this.inferenceContainerConfig(), other.inferenceContainerConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfiguredModelAlgorithmResponse").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("ConfiguredModelAlgorithmArn", (Object)this.configuredModelAlgorithmArn()).add("Name", (Object)this.name()).add("TrainingContainerConfig", (Object)this.trainingContainerConfig()).add("InferenceContainerConfig", (Object)this.inferenceContainerConfig()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "configuredModelAlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "trainingContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingContainerConfig()));
            }
            case "inferenceContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceContainerConfig()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("configuredModelAlgorithmArn", CONFIGURED_MODEL_ALGORITHM_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trainingContainerConfig", TRAINING_CONTAINER_CONFIG_FIELD);
        map.put("inferenceContainerConfig", INFERENCE_CONTAINER_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredModelAlgorithmResponse, T> g) {
        return obj -> g.apply((GetConfiguredModelAlgorithmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String configuredModelAlgorithmArn;
        private String name;
        private ContainerConfig trainingContainerConfig;
        private InferenceContainerConfig inferenceContainerConfig;
        private String roleArn;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredModelAlgorithmResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.configuredModelAlgorithmArn(model.configuredModelAlgorithmArn);
            this.name(model.name);
            this.trainingContainerConfig(model.trainingContainerConfig);
            this.inferenceContainerConfig(model.inferenceContainerConfig);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.tags(model.tags);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredModelAlgorithmArn() {
            return this.configuredModelAlgorithmArn;
        }

        public final void setConfiguredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
        }

        @Override
        public final Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContainerConfig.Builder getTrainingContainerConfig() {
            return this.trainingContainerConfig != null ? this.trainingContainerConfig.toBuilder() : null;
        }

        public final void setTrainingContainerConfig(ContainerConfig.BuilderImpl trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig != null ? trainingContainerConfig.build() : null;
        }

        @Override
        public final Builder trainingContainerConfig(ContainerConfig trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig;
            return this;
        }

        public final InferenceContainerConfig.Builder getInferenceContainerConfig() {
            return this.inferenceContainerConfig != null ? this.inferenceContainerConfig.toBuilder() : null;
        }

        public final void setInferenceContainerConfig(InferenceContainerConfig.BuilderImpl inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig != null ? inferenceContainerConfig.build() : null;
        }

        @Override
        public final Builder inferenceContainerConfig(InferenceContainerConfig inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GetConfiguredModelAlgorithmResponse build() {
            return new GetConfiguredModelAlgorithmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfiguredModelAlgorithmResponse> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder configuredModelAlgorithmArn(String var1);

        public Builder name(String var1);

        public Builder trainingContainerConfig(ContainerConfig var1);

        default public Builder trainingContainerConfig(Consumer<ContainerConfig.Builder> trainingContainerConfig) {
            return this.trainingContainerConfig((ContainerConfig)((ContainerConfig.Builder)ContainerConfig.builder().applyMutation(trainingContainerConfig)).build());
        }

        public Builder inferenceContainerConfig(InferenceContainerConfig var1);

        default public Builder inferenceContainerConfig(Consumer<InferenceContainerConfig.Builder> inferenceContainerConfig) {
            return this.inferenceContainerConfig((InferenceContainerConfig)((InferenceContainerConfig.Builder)InferenceContainerConfig.builder().applyMutation(inferenceContainerConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);
    }
}

